<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTarif ArrayType
 * @subpackage Arrays
 */
class ArrayOfTarif extends AbstractStructArrayBase
{
    /**
     * The Tarif
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Tarif[]
     */
    public $Tarif;
    /**
     * Constructor method for ArrayOfTarif
     * @uses ArrayOfTarif::setTarif()
     * @param \StructType\Tarif[] $tarif
     */
    public function __construct(array $tarif = array())
    {
        $this
            ->setTarif($tarif);
    }
    /**
     * Get Tarif value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Tarif[]|null
     */
    public function getTarif()
    {
        return isset($this->Tarif) ? $this->Tarif : null;
    }
    /**
     * Set Tarif value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tarif[] $tarif
     * @return \ArrayType\ArrayOfTarif
     */
    public function setTarif(array $tarif = array())
    {
        foreach ($tarif as $arrayOfTarifTarifItem) {
            // validation for constraint: itemType
            if (!$arrayOfTarifTarifItem instanceof \StructType\Tarif) {
                throw new \InvalidArgumentException(sprintf('The Tarif property can only contain items of \StructType\Tarif, "%s" given', is_object($arrayOfTarifTarifItem) ? get_class($arrayOfTarifTarifItem) : gettype($arrayOfTarifTarifItem)), __LINE__);
            }
        }
        if (is_null($tarif) || (is_array($tarif) && empty($tarif))) {
            unset($this->Tarif);
        } else {
            $this->Tarif = $tarif;
        }
        return $this;
    }
    /**
     * Add item to Tarif value
     * @throws \InvalidArgumentException
     * @param \StructType\Tarif $item
     * @return \ArrayType\ArrayOfTarif
     */
    public function addToTarif(\StructType\Tarif $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tarif) {
            throw new \InvalidArgumentException(sprintf('The Tarif property can only contain items of \StructType\Tarif, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tarif[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Tarif|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Tarif|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Tarif|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Tarif|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Tarif|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Tarif
     */
    public function getAttributeName()
    {
        return 'Tarif';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTarif
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
