<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJour ArrayType
 * @subpackage Arrays
 */
class ArrayOfJour extends AbstractStructArrayBase
{
    /**
     * The Jour
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Jour[]
     */
    public $Jour;
    /**
     * Constructor method for ArrayOfJour
     * @uses ArrayOfJour::setJour()
     * @param \StructType\Jour[] $jour
     */
    public function __construct(array $jour = array())
    {
        $this
            ->setJour($jour);
    }
    /**
     * Get Jour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Jour[]|null
     */
    public function getJour()
    {
        return isset($this->Jour) ? $this->Jour : null;
    }
    /**
     * Set Jour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Jour[] $jour
     * @return \ArrayType\ArrayOfJour
     */
    public function setJour(array $jour = array())
    {
        foreach ($jour as $arrayOfJourJourItem) {
            // validation for constraint: itemType
            if (!$arrayOfJourJourItem instanceof \StructType\Jour) {
                throw new \InvalidArgumentException(sprintf('The Jour property can only contain items of \StructType\Jour, "%s" given', is_object($arrayOfJourJourItem) ? get_class($arrayOfJourJourItem) : gettype($arrayOfJourJourItem)), __LINE__);
            }
        }
        if (is_null($jour) || (is_array($jour) && empty($jour))) {
            unset($this->Jour);
        } else {
            $this->Jour = $jour;
        }
        return $this;
    }
    /**
     * Add item to Jour value
     * @throws \InvalidArgumentException
     * @param \StructType\Jour $item
     * @return \ArrayType\ArrayOfJour
     */
    public function addToJour(\StructType\Jour $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Jour) {
            throw new \InvalidArgumentException(sprintf('The Jour property can only contain items of \StructType\Jour, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Jour[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Jour|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Jour|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Jour|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Jour|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Jour|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Jour
     */
    public function getAttributeName()
    {
        return 'Jour';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
