<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReponsePlanning StructType
 * @subpackage Structs
 */
class ReponsePlanning extends AbstractStructBase
{
    /**
     * The Resultat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resultat;
    /**
     * The CodeErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeErreur;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * The ListeCreneau
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCreneau
     */
    public $ListeCreneau;
    /**
     * The ListeJour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJour
     */
    public $ListeJour;
    /**
     * Constructor method for ReponsePlanning
     * @uses ReponsePlanning::setResultat()
     * @uses ReponsePlanning::setCodeErreur()
     * @uses ReponsePlanning::setLibelleErreur()
     * @uses ReponsePlanning::setListeCreneau()
     * @uses ReponsePlanning::setListeJour()
     * @param string $resultat
     * @param string $codeErreur
     * @param string $libelleErreur
     * @param \ArrayType\ArrayOfCreneau $listeCreneau
     * @param \ArrayType\ArrayOfJour $listeJour
     */
    public function __construct($resultat = null, $codeErreur = null, $libelleErreur = null, \ArrayType\ArrayOfCreneau $listeCreneau = null, \ArrayType\ArrayOfJour $listeJour = null)
    {
        $this
            ->setResultat($resultat)
            ->setCodeErreur($codeErreur)
            ->setLibelleErreur($libelleErreur)
            ->setListeCreneau($listeCreneau)
            ->setListeJour($listeJour);
    }
    /**
     * Get Resultat value
     * @return string|null
     */
    public function getResultat()
    {
        return $this->Resultat;
    }
    /**
     * Set Resultat value
     * @param string $resultat
     * @return \StructType\ReponsePlanning
     */
    public function setResultat($resultat = null)
    {
        // validation for constraint: string
        if (!is_null($resultat) && !is_string($resultat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultat)), __LINE__);
        }
        $this->Resultat = $resultat;
        return $this;
    }
    /**
     * Get CodeErreur value
     * @return string|null
     */
    public function getCodeErreur()
    {
        return $this->CodeErreur;
    }
    /**
     * Set CodeErreur value
     * @param string $codeErreur
     * @return \StructType\ReponsePlanning
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: string
        if (!is_null($codeErreur) && !is_string($codeErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeErreur)), __LINE__);
        }
        $this->CodeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\ReponsePlanning
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Get ListeCreneau value
     * @return \ArrayType\ArrayOfCreneau|null
     */
    public function getListeCreneau()
    {
        return $this->ListeCreneau;
    }
    /**
     * Set ListeCreneau value
     * @param \ArrayType\ArrayOfCreneau $listeCreneau
     * @return \StructType\ReponsePlanning
     */
    public function setListeCreneau(\ArrayType\ArrayOfCreneau $listeCreneau = null)
    {
        $this->ListeCreneau = $listeCreneau;
        return $this;
    }
    /**
     * Get ListeJour value
     * @return \ArrayType\ArrayOfJour|null
     */
    public function getListeJour()
    {
        return $this->ListeJour;
    }
    /**
     * Set ListeJour value
     * @param \ArrayType\ArrayOfJour $listeJour
     * @return \StructType\ReponsePlanning
     */
    public function setListeJour(\ArrayType\ArrayOfJour $listeJour = null)
    {
        $this->ListeJour = $listeJour;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReponsePlanning
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
