<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReponseOption StructType
 * @subpackage Structs
 */
class ReponseOption extends AbstractStructBase
{
    /**
     * The Resultat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resultat;
    /**
     * The CodeErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeErreur;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * The ListeOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption
     */
    public $ListeOption;
    /**
     * Constructor method for ReponseOption
     * @uses ReponseOption::setResultat()
     * @uses ReponseOption::setCodeErreur()
     * @uses ReponseOption::setLibelleErreur()
     * @uses ReponseOption::setListeOption()
     * @param string $resultat
     * @param string $codeErreur
     * @param string $libelleErreur
     * @param \ArrayType\ArrayOfOption $listeOption
     */
    public function __construct($resultat = null, $codeErreur = null, $libelleErreur = null, \ArrayType\ArrayOfOption $listeOption = null)
    {
        $this
            ->setResultat($resultat)
            ->setCodeErreur($codeErreur)
            ->setLibelleErreur($libelleErreur)
            ->setListeOption($listeOption);
    }
    /**
     * Get Resultat value
     * @return string|null
     */
    public function getResultat()
    {
        return $this->Resultat;
    }
    /**
     * Set Resultat value
     * @param string $resultat
     * @return \StructType\ReponseOption
     */
    public function setResultat($resultat = null)
    {
        // validation for constraint: string
        if (!is_null($resultat) && !is_string($resultat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultat)), __LINE__);
        }
        $this->Resultat = $resultat;
        return $this;
    }
    /**
     * Get CodeErreur value
     * @return string|null
     */
    public function getCodeErreur()
    {
        return $this->CodeErreur;
    }
    /**
     * Set CodeErreur value
     * @param string $codeErreur
     * @return \StructType\ReponseOption
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: string
        if (!is_null($codeErreur) && !is_string($codeErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeErreur)), __LINE__);
        }
        $this->CodeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\ReponseOption
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Get ListeOption value
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getListeOption()
    {
        return $this->ListeOption;
    }
    /**
     * Set ListeOption value
     * @param \ArrayType\ArrayOfOption $listeOption
     * @return \StructType\ReponseOption
     */
    public function setListeOption(\ArrayType\ArrayOfOption $listeOption = null)
    {
        $this->ListeOption = $listeOption;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReponseOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
