<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Option StructType
 * @subpackage Structs
 */
class Option extends AbstractStructBase
{
    /**
     * The CodeOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeOption;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Choix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Choix;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * The ListeChoix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfChoix
     */
    public $ListeChoix;
    /**
     * Constructor method for Option
     * @uses Option::setCodeOption()
     * @uses Option::setType()
     * @uses Option::setChoix()
     * @uses Option::setStyle()
     * @uses Option::setLibelle()
     * @uses Option::setListeChoix()
     * @param string $codeOption
     * @param string $type
     * @param string $choix
     * @param string $style
     * @param string $libelle
     * @param \ArrayType\ArrayOfChoix $listeChoix
     */
    public function __construct($codeOption = null, $type = null, $choix = null, $style = null, $libelle = null, \ArrayType\ArrayOfChoix $listeChoix = null)
    {
        $this
            ->setCodeOption($codeOption)
            ->setType($type)
            ->setChoix($choix)
            ->setStyle($style)
            ->setLibelle($libelle)
            ->setListeChoix($listeChoix);
    }
    /**
     * Get CodeOption value
     * @return string|null
     */
    public function getCodeOption()
    {
        return $this->CodeOption;
    }
    /**
     * Set CodeOption value
     * @param string $codeOption
     * @return \StructType\Option
     */
    public function setCodeOption($codeOption = null)
    {
        // validation for constraint: string
        if (!is_null($codeOption) && !is_string($codeOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeOption)), __LINE__);
        }
        $this->CodeOption = $codeOption;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Option
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Choix value
     * @return string|null
     */
    public function getChoix()
    {
        return $this->Choix;
    }
    /**
     * Set Choix value
     * @param string $choix
     * @return \StructType\Option
     */
    public function setChoix($choix = null)
    {
        // validation for constraint: string
        if (!is_null($choix) && !is_string($choix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($choix)), __LINE__);
        }
        $this->Choix = $choix;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @param string $style
     * @return \StructType\Option
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($style)), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Option
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get ListeChoix value
     * @return \ArrayType\ArrayOfChoix|null
     */
    public function getListeChoix()
    {
        return $this->ListeChoix;
    }
    /**
     * Set ListeChoix value
     * @param \ArrayType\ArrayOfChoix $listeChoix
     * @return \StructType\Option
     */
    public function setListeChoix(\ArrayType\ArrayOfChoix $listeChoix = null)
    {
        $this->ListeChoix = $listeChoix;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Option
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
