<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contenu StructType
 * @subpackage Structs
 */
class Contenu extends AbstractStructBase
{
    /**
     * The Prix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Prix;
    /**
     * The HeureDebut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HeureDebut;
    /**
     * The HeureFin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $HeureFin;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * The CodeCentre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeCentre;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Ville
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ville;
    /**
     * Constructor method for Contenu
     * @uses Contenu::setPrix()
     * @uses Contenu::setHeureDebut()
     * @uses Contenu::setHeureFin()
     * @uses Contenu::setStyle()
     * @uses Contenu::setLibelle()
     * @uses Contenu::setCodeCentre()
     * @uses Contenu::setType()
     * @uses Contenu::setVille()
     * @param float $prix
     * @param string $heureDebut
     * @param string $heureFin
     * @param string $style
     * @param string $libelle
     * @param string $codeCentre
     * @param string $type
     * @param string $ville
     */
    public function __construct($prix = null, $heureDebut = null, $heureFin = null, $style = null, $libelle = null, $codeCentre = null, $type = null, $ville = null)
    {
        $this
            ->setPrix($prix)
            ->setHeureDebut($heureDebut)
            ->setHeureFin($heureFin)
            ->setStyle($style)
            ->setLibelle($libelle)
            ->setCodeCentre($codeCentre)
            ->setType($type)
            ->setVille($ville);
    }
    /**
     * Get Prix value
     * @return float
     */
    public function getPrix()
    {
        return $this->Prix;
    }
    /**
     * Set Prix value
     * @param float $prix
     * @return \StructType\Contenu
     */
    public function setPrix($prix = null)
    {
        $this->Prix = $prix;
        return $this;
    }
    /**
     * Get HeureDebut value
     * @return string|null
     */
    public function getHeureDebut()
    {
        return $this->HeureDebut;
    }
    /**
     * Set HeureDebut value
     * @param string $heureDebut
     * @return \StructType\Contenu
     */
    public function setHeureDebut($heureDebut = null)
    {
        // validation for constraint: string
        if (!is_null($heureDebut) && !is_string($heureDebut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($heureDebut)), __LINE__);
        }
        $this->HeureDebut = $heureDebut;
        return $this;
    }
    /**
     * Get HeureFin value
     * @return string|null
     */
    public function getHeureFin()
    {
        return $this->HeureFin;
    }
    /**
     * Set HeureFin value
     * @param string $heureFin
     * @return \StructType\Contenu
     */
    public function setHeureFin($heureFin = null)
    {
        // validation for constraint: string
        if (!is_null($heureFin) && !is_string($heureFin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($heureFin)), __LINE__);
        }
        $this->HeureFin = $heureFin;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @param string $style
     * @return \StructType\Contenu
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($style)), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Contenu
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get CodeCentre value
     * @return string|null
     */
    public function getCodeCentre()
    {
        return $this->CodeCentre;
    }
    /**
     * Set CodeCentre value
     * @param string $codeCentre
     * @return \StructType\Contenu
     */
    public function setCodeCentre($codeCentre = null)
    {
        // validation for constraint: string
        if (!is_null($codeCentre) && !is_string($codeCentre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeCentre)), __LINE__);
        }
        $this->CodeCentre = $codeCentre;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\Contenu
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Ville value
     * @return string|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param string $ville
     * @return \StructType\Contenu
     */
    public function setVille($ville = null)
    {
        // validation for constraint: string
        if (!is_null($ville) && !is_string($ville)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ville)), __LINE__);
        }
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contenu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
