<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Prestations ServiceType
 * @subpackage Services
 */
class Prestations extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Prestations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Prestations $parameters
     * @return \StructType\PrestationsResponse|bool
     */
    public function Prestations(\StructType\Prestations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Prestations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PrestationsCTonline
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PrestationsCTonline $parameters
     * @return \StructType\PrestationsCTonlineResponse|bool
     */
    public function PrestationsCTonline(\StructType\PrestationsCTonline $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PrestationsCTonline($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PrestationsCTonlineResponse|\StructType\PrestationsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
