<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Infos ServiceType
 * @subpackage Services
 */
class Infos extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InfosRelance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InfosRelance $parameters
     * @return \StructType\InfosRelanceResponse|bool
     */
    public function InfosRelance(\StructType\InfosRelance $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InfosRelance($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InfosRelanceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
