<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRdv ArrayType
 * @subpackage Arrays
 */
class ArrayOfRdv extends AbstractStructArrayBase
{
    /**
     * The Rdv
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Rdv[]
     */
    public $Rdv;
    /**
     * Constructor method for ArrayOfRdv
     * @uses ArrayOfRdv::setRdv()
     * @param \StructType\Rdv[] $rdv
     */
    public function __construct(array $rdv = array())
    {
        $this
            ->setRdv($rdv);
    }
    /**
     * Get Rdv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Rdv[]|null
     */
    public function getRdv()
    {
        return isset($this->Rdv) ? $this->Rdv : null;
    }
    /**
     * Set Rdv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Rdv[] $rdv
     * @return \ArrayType\ArrayOfRdv
     */
    public function setRdv(array $rdv = array())
    {
        foreach ($rdv as $arrayOfRdvRdvItem) {
            // validation for constraint: itemType
            if (!$arrayOfRdvRdvItem instanceof \StructType\Rdv) {
                throw new \InvalidArgumentException(sprintf('The Rdv property can only contain items of \StructType\Rdv, "%s" given', is_object($arrayOfRdvRdvItem) ? get_class($arrayOfRdvRdvItem) : gettype($arrayOfRdvRdvItem)), __LINE__);
            }
        }
        if (is_null($rdv) || (is_array($rdv) && empty($rdv))) {
            unset($this->Rdv);
        } else {
            $this->Rdv = $rdv;
        }
        return $this;
    }
    /**
     * Add item to Rdv value
     * @throws \InvalidArgumentException
     * @param \StructType\Rdv $item
     * @return \ArrayType\ArrayOfRdv
     */
    public function addToRdv(\StructType\Rdv $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Rdv) {
            throw new \InvalidArgumentException(sprintf('The Rdv property can only contain items of \StructType\Rdv, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Rdv[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Rdv|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Rdv|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Rdv|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Rdv|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Rdv|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Rdv
     */
    public function getAttributeName()
    {
        return 'Rdv';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRdv
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
