<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfHoraire ArrayType
 * @subpackage Arrays
 */
class ArrayOfHoraire extends AbstractStructArrayBase
{
    /**
     * The Horaire
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Horaire[]
     */
    public $Horaire;
    /**
     * Constructor method for ArrayOfHoraire
     * @uses ArrayOfHoraire::setHoraire()
     * @param \StructType\Horaire[] $horaire
     */
    public function __construct(array $horaire = array())
    {
        $this
            ->setHoraire($horaire);
    }
    /**
     * Get Horaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Horaire[]|null
     */
    public function getHoraire()
    {
        return isset($this->Horaire) ? $this->Horaire : null;
    }
    /**
     * Set Horaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Horaire[] $horaire
     * @return \ArrayType\ArrayOfHoraire
     */
    public function setHoraire(array $horaire = array())
    {
        foreach ($horaire as $arrayOfHoraireHoraireItem) {
            // validation for constraint: itemType
            if (!$arrayOfHoraireHoraireItem instanceof \StructType\Horaire) {
                throw new \InvalidArgumentException(sprintf('The Horaire property can only contain items of \StructType\Horaire, "%s" given', is_object($arrayOfHoraireHoraireItem) ? get_class($arrayOfHoraireHoraireItem) : gettype($arrayOfHoraireHoraireItem)), __LINE__);
            }
        }
        if (is_null($horaire) || (is_array($horaire) && empty($horaire))) {
            unset($this->Horaire);
        } else {
            $this->Horaire = $horaire;
        }
        return $this;
    }
    /**
     * Add item to Horaire value
     * @throws \InvalidArgumentException
     * @param \StructType\Horaire $item
     * @return \ArrayType\ArrayOfHoraire
     */
    public function addToHoraire(\StructType\Horaire $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Horaire) {
            throw new \InvalidArgumentException(sprintf('The Horaire property can only contain items of \StructType\Horaire, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Horaire[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Horaire|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Horaire|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Horaire|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Horaire|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Horaire|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Horaire
     */
    public function getAttributeName()
    {
        return 'Horaire';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfHoraire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
