<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfGroupe ArrayType
 * @subpackage Arrays
 */
class ArrayOfGroupe extends AbstractStructArrayBase
{
    /**
     * The Groupe
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Groupe[]
     */
    public $Groupe;
    /**
     * Constructor method for ArrayOfGroupe
     * @uses ArrayOfGroupe::setGroupe()
     * @param \StructType\Groupe[] $groupe
     */
    public function __construct(array $groupe = array())
    {
        $this
            ->setGroupe($groupe);
    }
    /**
     * Get Groupe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Groupe[]|null
     */
    public function getGroupe()
    {
        return isset($this->Groupe) ? $this->Groupe : null;
    }
    /**
     * Set Groupe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Groupe[] $groupe
     * @return \ArrayType\ArrayOfGroupe
     */
    public function setGroupe(array $groupe = array())
    {
        foreach ($groupe as $arrayOfGroupeGroupeItem) {
            // validation for constraint: itemType
            if (!$arrayOfGroupeGroupeItem instanceof \StructType\Groupe) {
                throw new \InvalidArgumentException(sprintf('The Groupe property can only contain items of \StructType\Groupe, "%s" given', is_object($arrayOfGroupeGroupeItem) ? get_class($arrayOfGroupeGroupeItem) : gettype($arrayOfGroupeGroupeItem)), __LINE__);
            }
        }
        if (is_null($groupe) || (is_array($groupe) && empty($groupe))) {
            unset($this->Groupe);
        } else {
            $this->Groupe = $groupe;
        }
        return $this;
    }
    /**
     * Add item to Groupe value
     * @throws \InvalidArgumentException
     * @param \StructType\Groupe $item
     * @return \ArrayType\ArrayOfGroupe
     */
    public function addToGroupe(\StructType\Groupe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Groupe) {
            throw new \InvalidArgumentException(sprintf('The Groupe property can only contain items of \StructType\Groupe, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Groupe[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Groupe|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Groupe|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Groupe|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Groupe|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Groupe|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Groupe
     */
    public function getAttributeName()
    {
        return 'Groupe';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfGroupe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
