<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tarif StructType
 * @subpackage Structs
 */
class Tarif extends AbstractStructBase
{
    /**
     * The LibellePrestation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibellePrestation;
    /**
     * Constructor method for Tarif
     * @uses Tarif::setLibellePrestation()
     * @param string $libellePrestation
     */
    public function __construct($libellePrestation = null)
    {
        $this
            ->setLibellePrestation($libellePrestation);
    }
    /**
     * Get LibellePrestation value
     * @return string|null
     */
    public function getLibellePrestation()
    {
        return $this->LibellePrestation;
    }
    /**
     * Set LibellePrestation value
     * @param string $libellePrestation
     * @return \StructType\Tarif
     */
    public function setLibellePrestation($libellePrestation = null)
    {
        // validation for constraint: string
        if (!is_null($libellePrestation) && !is_string($libellePrestation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libellePrestation)), __LINE__);
        }
        $this->LibellePrestation = $libellePrestation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tarif
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
