<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReponseCoupon StructType
 * @subpackage Structs
 */
class ReponseCoupon extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Transaction;
    /**
     * The Resultat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resultat;
    /**
     * The CodeErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeErreur;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * Constructor method for ReponseCoupon
     * @uses ReponseCoupon::setTransaction()
     * @uses ReponseCoupon::setResultat()
     * @uses ReponseCoupon::setCodeErreur()
     * @uses ReponseCoupon::setLibelleErreur()
     * @param int $transaction
     * @param string $resultat
     * @param string $codeErreur
     * @param string $libelleErreur
     */
    public function __construct($transaction = null, $resultat = null, $codeErreur = null, $libelleErreur = null)
    {
        $this
            ->setTransaction($transaction)
            ->setResultat($resultat)
            ->setCodeErreur($codeErreur)
            ->setLibelleErreur($libelleErreur);
    }
    /**
     * Get Transaction value
     * @return int
     */
    public function getTransaction()
    {
        return $this->Transaction;
    }
    /**
     * Set Transaction value
     * @param int $transaction
     * @return \StructType\ReponseCoupon
     */
    public function setTransaction($transaction = null)
    {
        // validation for constraint: int
        if (!is_null($transaction) && !is_numeric($transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transaction)), __LINE__);
        }
        $this->Transaction = $transaction;
        return $this;
    }
    /**
     * Get Resultat value
     * @return string|null
     */
    public function getResultat()
    {
        return $this->Resultat;
    }
    /**
     * Set Resultat value
     * @param string $resultat
     * @return \StructType\ReponseCoupon
     */
    public function setResultat($resultat = null)
    {
        // validation for constraint: string
        if (!is_null($resultat) && !is_string($resultat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resultat)), __LINE__);
        }
        $this->Resultat = $resultat;
        return $this;
    }
    /**
     * Get CodeErreur value
     * @return string|null
     */
    public function getCodeErreur()
    {
        return $this->CodeErreur;
    }
    /**
     * Set CodeErreur value
     * @param string $codeErreur
     * @return \StructType\ReponseCoupon
     */
    public function setCodeErreur($codeErreur = null)
    {
        // validation for constraint: string
        if (!is_null($codeErreur) && !is_string($codeErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeErreur)), __LINE__);
        }
        $this->CodeErreur = $codeErreur;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\ReponseCoupon
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReponseCoupon
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
