<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Prestation StructType
 * @subpackage Structs
 */
class Prestation extends AbstractStructBase
{
    /**
     * The DateOffre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateOffre;
    /**
     * The CodePrestation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodePrestation;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * The CodeActivite
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeActivite;
    /**
     * The Duree
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Duree;
    /**
     * The PrixReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrixReference;
    /**
     * The TypePrestation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypePrestation;
    /**
     * The PrixMinimum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrixMinimum;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The PrixOffre
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrixOffre;
    /**
     * Constructor method for Prestation
     * @uses Prestation::setDateOffre()
     * @uses Prestation::setCodePrestation()
     * @uses Prestation::setLibelle()
     * @uses Prestation::setCodeActivite()
     * @uses Prestation::setDuree()
     * @uses Prestation::setPrixReference()
     * @uses Prestation::setTypePrestation()
     * @uses Prestation::setPrixMinimum()
     * @uses Prestation::setMessage()
     * @uses Prestation::setPrixOffre()
     * @param string $dateOffre
     * @param string $codePrestation
     * @param string $libelle
     * @param string $codeActivite
     * @param string $duree
     * @param string $prixReference
     * @param string $typePrestation
     * @param string $prixMinimum
     * @param string $message
     * @param string $prixOffre
     */
    public function __construct($dateOffre = null, $codePrestation = null, $libelle = null, $codeActivite = null, $duree = null, $prixReference = null, $typePrestation = null, $prixMinimum = null, $message = null, $prixOffre = null)
    {
        $this
            ->setDateOffre($dateOffre)
            ->setCodePrestation($codePrestation)
            ->setLibelle($libelle)
            ->setCodeActivite($codeActivite)
            ->setDuree($duree)
            ->setPrixReference($prixReference)
            ->setTypePrestation($typePrestation)
            ->setPrixMinimum($prixMinimum)
            ->setMessage($message)
            ->setPrixOffre($prixOffre);
    }
    /**
     * Get DateOffre value
     * @return string
     */
    public function getDateOffre()
    {
        return $this->DateOffre;
    }
    /**
     * Set DateOffre value
     * @param string $dateOffre
     * @return \StructType\Prestation
     */
    public function setDateOffre($dateOffre = null)
    {
        // validation for constraint: string
        if (!is_null($dateOffre) && !is_string($dateOffre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOffre)), __LINE__);
        }
        $this->DateOffre = $dateOffre;
        return $this;
    }
    /**
     * Get CodePrestation value
     * @return string|null
     */
    public function getCodePrestation()
    {
        return $this->CodePrestation;
    }
    /**
     * Set CodePrestation value
     * @param string $codePrestation
     * @return \StructType\Prestation
     */
    public function setCodePrestation($codePrestation = null)
    {
        // validation for constraint: string
        if (!is_null($codePrestation) && !is_string($codePrestation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codePrestation)), __LINE__);
        }
        $this->CodePrestation = $codePrestation;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Prestation
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get CodeActivite value
     * @return string|null
     */
    public function getCodeActivite()
    {
        return $this->CodeActivite;
    }
    /**
     * Set CodeActivite value
     * @param string $codeActivite
     * @return \StructType\Prestation
     */
    public function setCodeActivite($codeActivite = null)
    {
        // validation for constraint: string
        if (!is_null($codeActivite) && !is_string($codeActivite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeActivite)), __LINE__);
        }
        $this->CodeActivite = $codeActivite;
        return $this;
    }
    /**
     * Get Duree value
     * @return string|null
     */
    public function getDuree()
    {
        return $this->Duree;
    }
    /**
     * Set Duree value
     * @param string $duree
     * @return \StructType\Prestation
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: string
        if (!is_null($duree) && !is_string($duree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($duree)), __LINE__);
        }
        $this->Duree = $duree;
        return $this;
    }
    /**
     * Get PrixReference value
     * @return string|null
     */
    public function getPrixReference()
    {
        return $this->PrixReference;
    }
    /**
     * Set PrixReference value
     * @param string $prixReference
     * @return \StructType\Prestation
     */
    public function setPrixReference($prixReference = null)
    {
        // validation for constraint: string
        if (!is_null($prixReference) && !is_string($prixReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prixReference)), __LINE__);
        }
        $this->PrixReference = $prixReference;
        return $this;
    }
    /**
     * Get TypePrestation value
     * @return string|null
     */
    public function getTypePrestation()
    {
        return $this->TypePrestation;
    }
    /**
     * Set TypePrestation value
     * @param string $typePrestation
     * @return \StructType\Prestation
     */
    public function setTypePrestation($typePrestation = null)
    {
        // validation for constraint: string
        if (!is_null($typePrestation) && !is_string($typePrestation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typePrestation)), __LINE__);
        }
        $this->TypePrestation = $typePrestation;
        return $this;
    }
    /**
     * Get PrixMinimum value
     * @return string|null
     */
    public function getPrixMinimum()
    {
        return $this->PrixMinimum;
    }
    /**
     * Set PrixMinimum value
     * @param string $prixMinimum
     * @return \StructType\Prestation
     */
    public function setPrixMinimum($prixMinimum = null)
    {
        // validation for constraint: string
        if (!is_null($prixMinimum) && !is_string($prixMinimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prixMinimum)), __LINE__);
        }
        $this->PrixMinimum = $prixMinimum;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\Prestation
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get PrixOffre value
     * @return string|null
     */
    public function getPrixOffre()
    {
        return $this->PrixOffre;
    }
    /**
     * Set PrixOffre value
     * @param string $prixOffre
     * @return \StructType\Prestation
     */
    public function setPrixOffre($prixOffre = null)
    {
        // validation for constraint: string
        if (!is_null($prixOffre) && !is_string($prixOffre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prixOffre)), __LINE__);
        }
        $this->PrixOffre = $prixOffre;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Prestation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
