<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Jour StructType
 * @subpackage Structs
 */
class Jour extends AbstractStructBase
{
    /**
     * The DateJour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateJour;
    /**
     * The LibelleJour
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleJour;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * The ListeRdv
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfRdv
     */
    public $ListeRdv;
    /**
     * Constructor method for Jour
     * @uses Jour::setDateJour()
     * @uses Jour::setLibelleJour()
     * @uses Jour::setStyle()
     * @uses Jour::setListeRdv()
     * @param string $dateJour
     * @param string $libelleJour
     * @param string $style
     * @param \ArrayType\ArrayOfRdv $listeRdv
     */
    public function __construct($dateJour = null, $libelleJour = null, $style = null, \ArrayType\ArrayOfRdv $listeRdv = null)
    {
        $this
            ->setDateJour($dateJour)
            ->setLibelleJour($libelleJour)
            ->setStyle($style)
            ->setListeRdv($listeRdv);
    }
    /**
     * Get DateJour value
     * @return string|null
     */
    public function getDateJour()
    {
        return $this->DateJour;
    }
    /**
     * Set DateJour value
     * @param string $dateJour
     * @return \StructType\Jour
     */
    public function setDateJour($dateJour = null)
    {
        // validation for constraint: string
        if (!is_null($dateJour) && !is_string($dateJour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateJour)), __LINE__);
        }
        $this->DateJour = $dateJour;
        return $this;
    }
    /**
     * Get LibelleJour value
     * @return string|null
     */
    public function getLibelleJour()
    {
        return $this->LibelleJour;
    }
    /**
     * Set LibelleJour value
     * @param string $libelleJour
     * @return \StructType\Jour
     */
    public function setLibelleJour($libelleJour = null)
    {
        // validation for constraint: string
        if (!is_null($libelleJour) && !is_string($libelleJour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleJour)), __LINE__);
        }
        $this->LibelleJour = $libelleJour;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @param string $style
     * @return \StructType\Jour
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($style)), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Get ListeRdv value
     * @return \ArrayType\ArrayOfRdv|null
     */
    public function getListeRdv()
    {
        return $this->ListeRdv;
    }
    /**
     * Set ListeRdv value
     * @param \ArrayType\ArrayOfRdv $listeRdv
     * @return \StructType\Jour
     */
    public function setListeRdv(\ArrayType\ArrayOfRdv $listeRdv = null)
    {
        $this->ListeRdv = $listeRdv;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Jour
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
