<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Groupe StructType
 * @subpackage Structs
 */
class Groupe extends AbstractStructBase
{
    /**
     * The CodeGroupe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeGroupe;
    /**
     * The RaisonSocial
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RaisonSocial;
    /**
     * The Adresse1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adresse1;
    /**
     * The Adresse2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adresse2;
    /**
     * The CodePostal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodePostal;
    /**
     * The Ville
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ville;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The GPS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GPS;
    /**
     * The ListePhoto
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPhoto
     */
    public $ListePhoto;
    /**
     * Constructor method for Groupe
     * @uses Groupe::setCodeGroupe()
     * @uses Groupe::setRaisonSocial()
     * @uses Groupe::setAdresse1()
     * @uses Groupe::setAdresse2()
     * @uses Groupe::setCodePostal()
     * @uses Groupe::setVille()
     * @uses Groupe::setTelephone()
     * @uses Groupe::setEmail()
     * @uses Groupe::setGPS()
     * @uses Groupe::setListePhoto()
     * @param string $codeGroupe
     * @param string $raisonSocial
     * @param string $adresse1
     * @param string $adresse2
     * @param string $codePostal
     * @param string $ville
     * @param string $telephone
     * @param string $email
     * @param string $gPS
     * @param \ArrayType\ArrayOfPhoto $listePhoto
     */
    public function __construct($codeGroupe = null, $raisonSocial = null, $adresse1 = null, $adresse2 = null, $codePostal = null, $ville = null, $telephone = null, $email = null, $gPS = null, \ArrayType\ArrayOfPhoto $listePhoto = null)
    {
        $this
            ->setCodeGroupe($codeGroupe)
            ->setRaisonSocial($raisonSocial)
            ->setAdresse1($adresse1)
            ->setAdresse2($adresse2)
            ->setCodePostal($codePostal)
            ->setVille($ville)
            ->setTelephone($telephone)
            ->setEmail($email)
            ->setGPS($gPS)
            ->setListePhoto($listePhoto);
    }
    /**
     * Get CodeGroupe value
     * @return string|null
     */
    public function getCodeGroupe()
    {
        return $this->CodeGroupe;
    }
    /**
     * Set CodeGroupe value
     * @param string $codeGroupe
     * @return \StructType\Groupe
     */
    public function setCodeGroupe($codeGroupe = null)
    {
        // validation for constraint: string
        if (!is_null($codeGroupe) && !is_string($codeGroupe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeGroupe)), __LINE__);
        }
        $this->CodeGroupe = $codeGroupe;
        return $this;
    }
    /**
     * Get RaisonSocial value
     * @return string|null
     */
    public function getRaisonSocial()
    {
        return $this->RaisonSocial;
    }
    /**
     * Set RaisonSocial value
     * @param string $raisonSocial
     * @return \StructType\Groupe
     */
    public function setRaisonSocial($raisonSocial = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSocial) && !is_string($raisonSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($raisonSocial)), __LINE__);
        }
        $this->RaisonSocial = $raisonSocial;
        return $this;
    }
    /**
     * Get Adresse1 value
     * @return string|null
     */
    public function getAdresse1()
    {
        return $this->Adresse1;
    }
    /**
     * Set Adresse1 value
     * @param string $adresse1
     * @return \StructType\Groupe
     */
    public function setAdresse1($adresse1 = null)
    {
        // validation for constraint: string
        if (!is_null($adresse1) && !is_string($adresse1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse1)), __LINE__);
        }
        $this->Adresse1 = $adresse1;
        return $this;
    }
    /**
     * Get Adresse2 value
     * @return string|null
     */
    public function getAdresse2()
    {
        return $this->Adresse2;
    }
    /**
     * Set Adresse2 value
     * @param string $adresse2
     * @return \StructType\Groupe
     */
    public function setAdresse2($adresse2 = null)
    {
        // validation for constraint: string
        if (!is_null($adresse2) && !is_string($adresse2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresse2)), __LINE__);
        }
        $this->Adresse2 = $adresse2;
        return $this;
    }
    /**
     * Get CodePostal value
     * @return string|null
     */
    public function getCodePostal()
    {
        return $this->CodePostal;
    }
    /**
     * Set CodePostal value
     * @param string $codePostal
     * @return \StructType\Groupe
     */
    public function setCodePostal($codePostal = null)
    {
        // validation for constraint: string
        if (!is_null($codePostal) && !is_string($codePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codePostal)), __LINE__);
        }
        $this->CodePostal = $codePostal;
        return $this;
    }
    /**
     * Get Ville value
     * @return string|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param string $ville
     * @return \StructType\Groupe
     */
    public function setVille($ville = null)
    {
        // validation for constraint: string
        if (!is_null($ville) && !is_string($ville)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ville)), __LINE__);
        }
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\Groupe
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Groupe
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get GPS value
     * @return string|null
     */
    public function getGPS()
    {
        return $this->GPS;
    }
    /**
     * Set GPS value
     * @param string $gPS
     * @return \StructType\Groupe
     */
    public function setGPS($gPS = null)
    {
        // validation for constraint: string
        if (!is_null($gPS) && !is_string($gPS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gPS)), __LINE__);
        }
        $this->GPS = $gPS;
        return $this;
    }
    /**
     * Get ListePhoto value
     * @return \ArrayType\ArrayOfPhoto|null
     */
    public function getListePhoto()
    {
        return $this->ListePhoto;
    }
    /**
     * Set ListePhoto value
     * @param \ArrayType\ArrayOfPhoto $listePhoto
     * @return \StructType\Groupe
     */
    public function setListePhoto(\ArrayType\ArrayOfPhoto $listePhoto = null)
    {
        $this->ListePhoto = $listePhoto;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Groupe
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
