<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Creneau StructType
 * @subpackage Structs
 */
class Creneau extends AbstractStructBase
{
    /**
     * The CodeCreneau
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeCreneau;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * The Debut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Debut;
    /**
     * The Fin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fin;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * Constructor method for Creneau
     * @uses Creneau::setCodeCreneau()
     * @uses Creneau::setLibelle()
     * @uses Creneau::setDebut()
     * @uses Creneau::setFin()
     * @uses Creneau::setStyle()
     * @param string $codeCreneau
     * @param string $libelle
     * @param string $debut
     * @param string $fin
     * @param string $style
     */
    public function __construct($codeCreneau = null, $libelle = null, $debut = null, $fin = null, $style = null)
    {
        $this
            ->setCodeCreneau($codeCreneau)
            ->setLibelle($libelle)
            ->setDebut($debut)
            ->setFin($fin)
            ->setStyle($style);
    }
    /**
     * Get CodeCreneau value
     * @return string|null
     */
    public function getCodeCreneau()
    {
        return $this->CodeCreneau;
    }
    /**
     * Set CodeCreneau value
     * @param string $codeCreneau
     * @return \StructType\Creneau
     */
    public function setCodeCreneau($codeCreneau = null)
    {
        // validation for constraint: string
        if (!is_null($codeCreneau) && !is_string($codeCreneau)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeCreneau)), __LINE__);
        }
        $this->CodeCreneau = $codeCreneau;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Creneau
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get Debut value
     * @return string|null
     */
    public function getDebut()
    {
        return $this->Debut;
    }
    /**
     * Set Debut value
     * @param string $debut
     * @return \StructType\Creneau
     */
    public function setDebut($debut = null)
    {
        // validation for constraint: string
        if (!is_null($debut) && !is_string($debut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debut)), __LINE__);
        }
        $this->Debut = $debut;
        return $this;
    }
    /**
     * Get Fin value
     * @return string|null
     */
    public function getFin()
    {
        return $this->Fin;
    }
    /**
     * Set Fin value
     * @param string $fin
     * @return \StructType\Creneau
     */
    public function setFin($fin = null)
    {
        // validation for constraint: string
        if (!is_null($fin) && !is_string($fin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fin)), __LINE__);
        }
        $this->Fin = $fin;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @param string $style
     * @return \StructType\Creneau
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($style)), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Creneau
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
