<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Choix StructType
 * @subpackage Structs
 */
class Choix extends AbstractStructBase
{
    /**
     * The EstPossible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EstPossible;
    /**
     * The EstObligatoire
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EstObligatoire;
    /**
     * The EstParDefaut
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EstParDefaut;
    /**
     * The CodeChoix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodeChoix;
    /**
     * The Libelle
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Libelle;
    /**
     * The PrixTTC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrixTTC;
    /**
     * The LibelleErreur
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LibelleErreur;
    /**
     * The Style
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Style;
    /**
     * Constructor method for Choix
     * @uses Choix::setEstPossible()
     * @uses Choix::setEstObligatoire()
     * @uses Choix::setEstParDefaut()
     * @uses Choix::setCodeChoix()
     * @uses Choix::setLibelle()
     * @uses Choix::setPrixTTC()
     * @uses Choix::setLibelleErreur()
     * @uses Choix::setStyle()
     * @param bool $estPossible
     * @param bool $estObligatoire
     * @param bool $estParDefaut
     * @param string $codeChoix
     * @param string $libelle
     * @param string $prixTTC
     * @param string $libelleErreur
     * @param string $style
     */
    public function __construct($estPossible = null, $estObligatoire = null, $estParDefaut = null, $codeChoix = null, $libelle = null, $prixTTC = null, $libelleErreur = null, $style = null)
    {
        $this
            ->setEstPossible($estPossible)
            ->setEstObligatoire($estObligatoire)
            ->setEstParDefaut($estParDefaut)
            ->setCodeChoix($codeChoix)
            ->setLibelle($libelle)
            ->setPrixTTC($prixTTC)
            ->setLibelleErreur($libelleErreur)
            ->setStyle($style);
    }
    /**
     * Get EstPossible value
     * @return bool
     */
    public function getEstPossible()
    {
        return $this->EstPossible;
    }
    /**
     * Set EstPossible value
     * @param bool $estPossible
     * @return \StructType\Choix
     */
    public function setEstPossible($estPossible = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPossible) && !is_bool($estPossible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estPossible)), __LINE__);
        }
        $this->EstPossible = $estPossible;
        return $this;
    }
    /**
     * Get EstObligatoire value
     * @return bool
     */
    public function getEstObligatoire()
    {
        return $this->EstObligatoire;
    }
    /**
     * Set EstObligatoire value
     * @param bool $estObligatoire
     * @return \StructType\Choix
     */
    public function setEstObligatoire($estObligatoire = null)
    {
        // validation for constraint: boolean
        if (!is_null($estObligatoire) && !is_bool($estObligatoire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estObligatoire)), __LINE__);
        }
        $this->EstObligatoire = $estObligatoire;
        return $this;
    }
    /**
     * Get EstParDefaut value
     * @return bool
     */
    public function getEstParDefaut()
    {
        return $this->EstParDefaut;
    }
    /**
     * Set EstParDefaut value
     * @param bool $estParDefaut
     * @return \StructType\Choix
     */
    public function setEstParDefaut($estParDefaut = null)
    {
        // validation for constraint: boolean
        if (!is_null($estParDefaut) && !is_bool($estParDefaut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estParDefaut)), __LINE__);
        }
        $this->EstParDefaut = $estParDefaut;
        return $this;
    }
    /**
     * Get CodeChoix value
     * @return string|null
     */
    public function getCodeChoix()
    {
        return $this->CodeChoix;
    }
    /**
     * Set CodeChoix value
     * @param string $codeChoix
     * @return \StructType\Choix
     */
    public function setCodeChoix($codeChoix = null)
    {
        // validation for constraint: string
        if (!is_null($codeChoix) && !is_string($codeChoix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeChoix)), __LINE__);
        }
        $this->CodeChoix = $codeChoix;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \StructType\Choix
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get PrixTTC value
     * @return string|null
     */
    public function getPrixTTC()
    {
        return $this->PrixTTC;
    }
    /**
     * Set PrixTTC value
     * @param string $prixTTC
     * @return \StructType\Choix
     */
    public function setPrixTTC($prixTTC = null)
    {
        // validation for constraint: string
        if (!is_null($prixTTC) && !is_string($prixTTC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prixTTC)), __LINE__);
        }
        $this->PrixTTC = $prixTTC;
        return $this;
    }
    /**
     * Get LibelleErreur value
     * @return string|null
     */
    public function getLibelleErreur()
    {
        return $this->LibelleErreur;
    }
    /**
     * Set LibelleErreur value
     * @param string $libelleErreur
     * @return \StructType\Choix
     */
    public function setLibelleErreur($libelleErreur = null)
    {
        // validation for constraint: string
        if (!is_null($libelleErreur) && !is_string($libelleErreur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($libelleErreur)), __LINE__);
        }
        $this->LibelleErreur = $libelleErreur;
        return $this;
    }
    /**
     * Get Style value
     * @return string|null
     */
    public function getStyle()
    {
        return $this->Style;
    }
    /**
     * Set Style value
     * @param string $style
     * @return \StructType\Choix
     */
    public function setStyle($style = null)
    {
        // validation for constraint: string
        if (!is_null($style) && !is_string($style)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($style)), __LINE__);
        }
        $this->Style = $style;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Choix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
