<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unsubscribe ServiceType
 * @subpackage Services
 */
class Unsubscribe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Unsubscribe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Unsubscribe $parameters
     * @return \StructType\UnsubscribeResponse|bool
     */
    public function Unsubscribe(\StructType\Unsubscribe $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->Unsubscribe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnsubscribeResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
