<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPrestation ArrayType
 * @subpackage Arrays
 */
class ArrayOfPrestation extends AbstractStructArrayBase
{
    /**
     * The Prestation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Prestation[]
     */
    public $Prestation;
    /**
     * Constructor method for ArrayOfPrestation
     * @uses ArrayOfPrestation::setPrestation()
     * @param \StructType\Prestation[] $prestation
     */
    public function __construct(array $prestation = array())
    {
        $this
            ->setPrestation($prestation);
    }
    /**
     * Get Prestation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Prestation[]|null
     */
    public function getPrestation()
    {
        return isset($this->Prestation) ? $this->Prestation : null;
    }
    /**
     * Set Prestation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Prestation[] $prestation
     * @return \ArrayType\ArrayOfPrestation
     */
    public function setPrestation(array $prestation = array())
    {
        foreach ($prestation as $arrayOfPrestationPrestationItem) {
            // validation for constraint: itemType
            if (!$arrayOfPrestationPrestationItem instanceof \StructType\Prestation) {
                throw new \InvalidArgumentException(sprintf('The Prestation property can only contain items of \StructType\Prestation, "%s" given', is_object($arrayOfPrestationPrestationItem) ? get_class($arrayOfPrestationPrestationItem) : gettype($arrayOfPrestationPrestationItem)), __LINE__);
            }
        }
        if (is_null($prestation) || (is_array($prestation) && empty($prestation))) {
            unset($this->Prestation);
        } else {
            $this->Prestation = $prestation;
        }
        return $this;
    }
    /**
     * Add item to Prestation value
     * @throws \InvalidArgumentException
     * @param \StructType\Prestation $item
     * @return \ArrayType\ArrayOfPrestation
     */
    public function addToPrestation(\StructType\Prestation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Prestation) {
            throw new \InvalidArgumentException(sprintf('The Prestation property can only contain items of \StructType\Prestation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Prestation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Prestation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Prestation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Prestation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Prestation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Prestation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Prestation
     */
    public function getAttributeName()
    {
        return 'Prestation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPrestation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
