<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPlageHoraire ArrayType
 * @subpackage Arrays
 */
class ArrayOfPlageHoraire extends AbstractStructArrayBase
{
    /**
     * The PlageHoraire
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PlageHoraire[]
     */
    public $PlageHoraire;
    /**
     * Constructor method for ArrayOfPlageHoraire
     * @uses ArrayOfPlageHoraire::setPlageHoraire()
     * @param \StructType\PlageHoraire[] $plageHoraire
     */
    public function __construct(array $plageHoraire = array())
    {
        $this
            ->setPlageHoraire($plageHoraire);
    }
    /**
     * Get PlageHoraire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PlageHoraire[]|null
     */
    public function getPlageHoraire()
    {
        return isset($this->PlageHoraire) ? $this->PlageHoraire : null;
    }
    /**
     * Set PlageHoraire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PlageHoraire[] $plageHoraire
     * @return \ArrayType\ArrayOfPlageHoraire
     */
    public function setPlageHoraire(array $plageHoraire = array())
    {
        foreach ($plageHoraire as $arrayOfPlageHorairePlageHoraireItem) {
            // validation for constraint: itemType
            if (!$arrayOfPlageHorairePlageHoraireItem instanceof \StructType\PlageHoraire) {
                throw new \InvalidArgumentException(sprintf('The PlageHoraire property can only contain items of \StructType\PlageHoraire, "%s" given', is_object($arrayOfPlageHorairePlageHoraireItem) ? get_class($arrayOfPlageHorairePlageHoraireItem) : gettype($arrayOfPlageHorairePlageHoraireItem)), __LINE__);
            }
        }
        if (is_null($plageHoraire) || (is_array($plageHoraire) && empty($plageHoraire))) {
            unset($this->PlageHoraire);
        } else {
            $this->PlageHoraire = $plageHoraire;
        }
        return $this;
    }
    /**
     * Add item to PlageHoraire value
     * @throws \InvalidArgumentException
     * @param \StructType\PlageHoraire $item
     * @return \ArrayType\ArrayOfPlageHoraire
     */
    public function addToPlageHoraire(\StructType\PlageHoraire $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PlageHoraire) {
            throw new \InvalidArgumentException(sprintf('The PlageHoraire property can only contain items of \StructType\PlageHoraire, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PlageHoraire[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PlageHoraire|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PlageHoraire|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PlageHoraire|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PlageHoraire|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PlageHoraire|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PlageHoraire
     */
    public function getAttributeName()
    {
        return 'PlageHoraire';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPlageHoraire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
