<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPhoto ArrayType
 * @subpackage Arrays
 */
class ArrayOfPhoto extends AbstractStructArrayBase
{
    /**
     * The Photo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Photo[]
     */
    public $Photo;
    /**
     * Constructor method for ArrayOfPhoto
     * @uses ArrayOfPhoto::setPhoto()
     * @param \StructType\Photo[] $photo
     */
    public function __construct(array $photo = array())
    {
        $this
            ->setPhoto($photo);
    }
    /**
     * Get Photo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Photo[]|null
     */
    public function getPhoto()
    {
        return isset($this->Photo) ? $this->Photo : null;
    }
    /**
     * Set Photo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Photo[] $photo
     * @return \ArrayType\ArrayOfPhoto
     */
    public function setPhoto(array $photo = array())
    {
        foreach ($photo as $arrayOfPhotoPhotoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPhotoPhotoItem instanceof \StructType\Photo) {
                throw new \InvalidArgumentException(sprintf('The Photo property can only contain items of \StructType\Photo, "%s" given', is_object($arrayOfPhotoPhotoItem) ? get_class($arrayOfPhotoPhotoItem) : gettype($arrayOfPhotoPhotoItem)), __LINE__);
            }
        }
        if (is_null($photo) || (is_array($photo) && empty($photo))) {
            unset($this->Photo);
        } else {
            $this->Photo = $photo;
        }
        return $this;
    }
    /**
     * Add item to Photo value
     * @throws \InvalidArgumentException
     * @param \StructType\Photo $item
     * @return \ArrayType\ArrayOfPhoto
     */
    public function addToPhoto(\StructType\Photo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Photo) {
            throw new \InvalidArgumentException(sprintf('The Photo property can only contain items of \StructType\Photo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Photo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Photo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Photo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Photo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Photo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Photo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Photo
     */
    public function getAttributeName()
    {
        return 'Photo';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPhoto
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
