<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfContenu ArrayType
 * @subpackage Arrays
 */
class ArrayOfContenu extends AbstractStructArrayBase
{
    /**
     * The Contenu
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contenu[]
     */
    public $Contenu;
    /**
     * Constructor method for ArrayOfContenu
     * @uses ArrayOfContenu::setContenu()
     * @param \StructType\Contenu[] $contenu
     */
    public function __construct(array $contenu = array())
    {
        $this
            ->setContenu($contenu);
    }
    /**
     * Get Contenu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contenu[]|null
     */
    public function getContenu()
    {
        return isset($this->Contenu) ? $this->Contenu : null;
    }
    /**
     * Set Contenu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Contenu[] $contenu
     * @return \ArrayType\ArrayOfContenu
     */
    public function setContenu(array $contenu = array())
    {
        foreach ($contenu as $arrayOfContenuContenuItem) {
            // validation for constraint: itemType
            if (!$arrayOfContenuContenuItem instanceof \StructType\Contenu) {
                throw new \InvalidArgumentException(sprintf('The Contenu property can only contain items of \StructType\Contenu, "%s" given', is_object($arrayOfContenuContenuItem) ? get_class($arrayOfContenuContenuItem) : gettype($arrayOfContenuContenuItem)), __LINE__);
            }
        }
        if (is_null($contenu) || (is_array($contenu) && empty($contenu))) {
            unset($this->Contenu);
        } else {
            $this->Contenu = $contenu;
        }
        return $this;
    }
    /**
     * Add item to Contenu value
     * @throws \InvalidArgumentException
     * @param \StructType\Contenu $item
     * @return \ArrayType\ArrayOfContenu
     */
    public function addToContenu(\StructType\Contenu $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Contenu) {
            throw new \InvalidArgumentException(sprintf('The Contenu property can only contain items of \StructType\Contenu, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Contenu[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Contenu|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Contenu|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Contenu|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Contenu|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Contenu|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Contenu
     */
    public function getAttributeName()
    {
        return 'Contenu';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfContenu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
