<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCentre ArrayType
 * @subpackage Arrays
 */
class ArrayOfCentre extends AbstractStructArrayBase
{
    /**
     * The Centre
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Centre[]
     */
    public $Centre;
    /**
     * Constructor method for ArrayOfCentre
     * @uses ArrayOfCentre::setCentre()
     * @param \StructType\Centre[] $centre
     */
    public function __construct(array $centre = array())
    {
        $this
            ->setCentre($centre);
    }
    /**
     * Get Centre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Centre[]|null
     */
    public function getCentre()
    {
        return isset($this->Centre) ? $this->Centre : null;
    }
    /**
     * Set Centre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Centre[] $centre
     * @return \ArrayType\ArrayOfCentre
     */
    public function setCentre(array $centre = array())
    {
        foreach ($centre as $arrayOfCentreCentreItem) {
            // validation for constraint: itemType
            if (!$arrayOfCentreCentreItem instanceof \StructType\Centre) {
                throw new \InvalidArgumentException(sprintf('The Centre property can only contain items of \StructType\Centre, "%s" given', is_object($arrayOfCentreCentreItem) ? get_class($arrayOfCentreCentreItem) : gettype($arrayOfCentreCentreItem)), __LINE__);
            }
        }
        if (is_null($centre) || (is_array($centre) && empty($centre))) {
            unset($this->Centre);
        } else {
            $this->Centre = $centre;
        }
        return $this;
    }
    /**
     * Add item to Centre value
     * @throws \InvalidArgumentException
     * @param \StructType\Centre $item
     * @return \ArrayType\ArrayOfCentre
     */
    public function addToCentre(\StructType\Centre $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Centre) {
            throw new \InvalidArgumentException(sprintf('The Centre property can only contain items of \StructType\Centre, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Centre[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Centre|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Centre|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Centre|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Centre|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Centre|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Centre
     */
    public function getAttributeName()
    {
        return 'Centre';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCentre
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
