<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfActivite ArrayType
 * @subpackage Arrays
 */
class ArrayOfActivite extends AbstractStructArrayBase
{
    /**
     * The Activite
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Activite[]
     */
    public $Activite;
    /**
     * Constructor method for ArrayOfActivite
     * @uses ArrayOfActivite::setActivite()
     * @param \StructType\Activite[] $activite
     */
    public function __construct(array $activite = array())
    {
        $this
            ->setActivite($activite);
    }
    /**
     * Get Activite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Activite[]|null
     */
    public function getActivite()
    {
        return isset($this->Activite) ? $this->Activite : null;
    }
    /**
     * Set Activite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Activite[] $activite
     * @return \ArrayType\ArrayOfActivite
     */
    public function setActivite(array $activite = array())
    {
        foreach ($activite as $arrayOfActiviteActiviteItem) {
            // validation for constraint: itemType
            if (!$arrayOfActiviteActiviteItem instanceof \StructType\Activite) {
                throw new \InvalidArgumentException(sprintf('The Activite property can only contain items of \StructType\Activite, "%s" given', is_object($arrayOfActiviteActiviteItem) ? get_class($arrayOfActiviteActiviteItem) : gettype($arrayOfActiviteActiviteItem)), __LINE__);
            }
        }
        if (is_null($activite) || (is_array($activite) && empty($activite))) {
            unset($this->Activite);
        } else {
            $this->Activite = $activite;
        }
        return $this;
    }
    /**
     * Add item to Activite value
     * @throws \InvalidArgumentException
     * @param \StructType\Activite $item
     * @return \ArrayType\ArrayOfActivite
     */
    public function addToActivite(\StructType\Activite $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Activite) {
            throw new \InvalidArgumentException(sprintf('The Activite property can only contain items of \StructType\Activite, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Activite[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Activite|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Activite|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Activite|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Activite|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Activite|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Activite
     */
    public function getAttributeName()
    {
        return 'Activite';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfActivite
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
