<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObtieneRelacionadosCFDI StructType
 * Meta information extracted from the WSDL
 * - type: tns:ObtieneRelacionadosCFDI
 * @subpackage Structs
 */
class ObtieneRelacionadosCFDI extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The contrasenia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contrasenia;
    /**
     * The idServicio
     * @var int
     */
    public $idServicio;
    /**
     * The RfcReceptor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RfcReceptor;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UUID;
    /**
     * The certificado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $certificado;
    /**
     * The RSAPK
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RSAPK;
    /**
     * Constructor method for ObtieneRelacionadosCFDI
     * @uses ObtieneRelacionadosCFDI::setUsuario()
     * @uses ObtieneRelacionadosCFDI::setContrasenia()
     * @uses ObtieneRelacionadosCFDI::setIdServicio()
     * @uses ObtieneRelacionadosCFDI::setRfcReceptor()
     * @uses ObtieneRelacionadosCFDI::setUUID()
     * @uses ObtieneRelacionadosCFDI::setCertificado()
     * @uses ObtieneRelacionadosCFDI::setRSAPK()
     * @param string $usuario
     * @param string $contrasenia
     * @param int $idServicio
     * @param string $rfcReceptor
     * @param string $uUID
     * @param string $certificado
     * @param string $rSAPK
     */
    public function __construct($usuario = null, $contrasenia = null, $idServicio = null, $rfcReceptor = null, $uUID = null, $certificado = null, $rSAPK = null)
    {
        $this
            ->setUsuario($usuario)
            ->setContrasenia($contrasenia)
            ->setIdServicio($idServicio)
            ->setRfcReceptor($rfcReceptor)
            ->setUUID($uUID)
            ->setCertificado($certificado)
            ->setRSAPK($rSAPK);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get contrasenia value
     * @return string|null
     */
    public function getContrasenia()
    {
        return $this->contrasenia;
    }
    /**
     * Set contrasenia value
     * @param string $contrasenia
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setContrasenia($contrasenia = null)
    {
        // validation for constraint: string
        if (!is_null($contrasenia) && !is_string($contrasenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrasenia, true), gettype($contrasenia)), __LINE__);
        }
        $this->contrasenia = $contrasenia;
        return $this;
    }
    /**
     * Get idServicio value
     * @return int|null
     */
    public function getIdServicio()
    {
        return $this->idServicio;
    }
    /**
     * Set idServicio value
     * @param int $idServicio
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setIdServicio($idServicio = null)
    {
        // validation for constraint: int
        if (!is_null($idServicio) && !(is_int($idServicio) || ctype_digit($idServicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idServicio, true), gettype($idServicio)), __LINE__);
        }
        $this->idServicio = $idServicio;
        return $this;
    }
    /**
     * Get RfcReceptor value
     * @return string|null
     */
    public function getRfcReceptor()
    {
        return $this->RfcReceptor;
    }
    /**
     * Set RfcReceptor value
     * @param string $rfcReceptor
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setRfcReceptor($rfcReceptor = null)
    {
        // validation for constraint: string
        if (!is_null($rfcReceptor) && !is_string($rfcReceptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rfcReceptor, true), gettype($rfcReceptor)), __LINE__);
        }
        $this->RfcReceptor = $rfcReceptor;
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get certificado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCertificado()
    {
        return isset($this->certificado) ? $this->certificado : null;
    }
    /**
     * Set certificado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $certificado
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setCertificado($certificado = null)
    {
        // validation for constraint: string
        if (!is_null($certificado) && !is_string($certificado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($certificado, true), gettype($certificado)), __LINE__);
        }
        if (is_null($certificado) || (is_array($certificado) && empty($certificado))) {
            unset($this->certificado);
        } else {
            $this->certificado = $certificado;
        }
        return $this;
    }
    /**
     * Get RSAPK value
     * @return string|null
     */
    public function getRSAPK()
    {
        return $this->RSAPK;
    }
    /**
     * Set RSAPK value
     * @param string $rSAPK
     * @return \StructType\ObtieneRelacionadosCFDI
     */
    public function setRSAPK($rSAPK = null)
    {
        // validation for constraint: string
        if (!is_null($rSAPK) && !is_string($rSAPK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rSAPK, true), gettype($rSAPK)), __LINE__);
        }
        $this->RSAPK = $rSAPK;
        return $this;
    }
}
