<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obtiene ServiceType
 * @subpackage Services
 */
class Obtiene extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ObtienePeticionesPendientes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtienePeticionesPendientes $parameters
     * @return \StructType\ObtienePeticionesPendientesResponse|bool
     */
    public function ObtienePeticionesPendientes(\StructType\ObtienePeticionesPendientes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtienePeticionesPendientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObtieneStatusCFDI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtieneStatusCFDI $parameters
     * @return \StructType\ObtieneStatusCFDIResponse|bool
     */
    public function ObtieneStatusCFDI(\StructType\ObtieneStatusCFDI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtieneStatusCFDI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObtieneRelacionadosCFDI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtieneRelacionadosCFDI $parameters
     * @return \StructType\ObtieneRelacionadosCFDIResponse|bool
     */
    public function ObtieneRelacionadosCFDI(\StructType\ObtieneRelacionadosCFDI $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtieneRelacionadosCFDI($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ObtieneRelacionadosCFDICA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObtieneRelacionadosCFDICA $parameters
     * @return \StructType\ObtieneRelacionadosCFDICAResponse|bool
     */
    public function ObtieneRelacionadosCFDICA(\StructType\ObtieneRelacionadosCFDICA $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ObtieneRelacionadosCFDICA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObtienePeticionesPendientesResponse|\StructType\ObtieneRelacionadosCFDICAResponse|\StructType\ObtieneRelacionadosCFDIResponse|\StructType\ObtieneStatusCFDIResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
