<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelarCFDICA2022 StructType
 * Meta information extracted from the WSDL
 * - type: tns:CancelarCFDICA2022
 * @subpackage Structs
 */
class CancelarCFDICA2022 extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The contrasenia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contrasenia;
    /**
     * The idServicio
     * @var int
     */
    public $idServicio;
    /**
     * The xml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $xml;
    /**
     * The Motivo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Motivo;
    /**
     * The FolioSustitucion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FolioSustitucion;
    /**
     * Constructor method for CancelarCFDICA2022
     * @uses CancelarCFDICA2022::setUsuario()
     * @uses CancelarCFDICA2022::setContrasenia()
     * @uses CancelarCFDICA2022::setIdServicio()
     * @uses CancelarCFDICA2022::setXml()
     * @uses CancelarCFDICA2022::setMotivo()
     * @uses CancelarCFDICA2022::setFolioSustitucion()
     * @param string $usuario
     * @param string $contrasenia
     * @param int $idServicio
     * @param string $xml
     * @param string $motivo
     * @param string $folioSustitucion
     */
    public function __construct($usuario = null, $contrasenia = null, $idServicio = null, $xml = null, $motivo = null, $folioSustitucion = null)
    {
        $this
            ->setUsuario($usuario)
            ->setContrasenia($contrasenia)
            ->setIdServicio($idServicio)
            ->setXml($xml)
            ->setMotivo($motivo)
            ->setFolioSustitucion($folioSustitucion);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\CancelarCFDICA2022
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get contrasenia value
     * @return string|null
     */
    public function getContrasenia()
    {
        return $this->contrasenia;
    }
    /**
     * Set contrasenia value
     * @param string $contrasenia
     * @return \StructType\CancelarCFDICA2022
     */
    public function setContrasenia($contrasenia = null)
    {
        // validation for constraint: string
        if (!is_null($contrasenia) && !is_string($contrasenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrasenia, true), gettype($contrasenia)), __LINE__);
        }
        $this->contrasenia = $contrasenia;
        return $this;
    }
    /**
     * Get idServicio value
     * @return int|null
     */
    public function getIdServicio()
    {
        return $this->idServicio;
    }
    /**
     * Set idServicio value
     * @param int $idServicio
     * @return \StructType\CancelarCFDICA2022
     */
    public function setIdServicio($idServicio = null)
    {
        // validation for constraint: int
        if (!is_null($idServicio) && !(is_int($idServicio) || ctype_digit($idServicio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idServicio, true), gettype($idServicio)), __LINE__);
        }
        $this->idServicio = $idServicio;
        return $this;
    }
    /**
     * Get xml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXml()
    {
        return isset($this->xml) ? $this->xml : null;
    }
    /**
     * Set xml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xml
     * @return \StructType\CancelarCFDICA2022
     */
    public function setXml($xml = null)
    {
        // validation for constraint: string
        if (!is_null($xml) && !is_string($xml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xml, true), gettype($xml)), __LINE__);
        }
        if (is_null($xml) || (is_array($xml) && empty($xml))) {
            unset($this->xml);
        } else {
            $this->xml = $xml;
        }
        return $this;
    }
    /**
     * Get Motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->Motivo;
    }
    /**
     * Set Motivo value
     * @param string $motivo
     * @return \StructType\CancelarCFDICA2022
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->Motivo = $motivo;
        return $this;
    }
    /**
     * Get FolioSustitucion value
     * @return string|null
     */
    public function getFolioSustitucion()
    {
        return $this->FolioSustitucion;
    }
    /**
     * Set FolioSustitucion value
     * @param string $folioSustitucion
     * @return \StructType\CancelarCFDICA2022
     */
    public function setFolioSustitucion($folioSustitucion = null)
    {
        // validation for constraint: string
        if (!is_null($folioSustitucion) && !is_string($folioSustitucion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folioSustitucion, true), gettype($folioSustitucion)), __LINE__);
        }
        $this->FolioSustitucion = $folioSustitucion;
        return $this;
    }
}
