<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for createShipmentOrder operation/method
 */
if ($create->createShipmentOrder(new \StructType\CreateShipmentOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \ServiceType\Validate($options);
$validate->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for validateShipment operation/method
 */
if ($validate->validateShipment(new \StructType\ValidateShipmentOrderRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for deleteShipmentOrder operation/method
 */
if ($delete->deleteShipmentOrder(new \StructType\DeleteShipmentOrderRequest()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Do ServiceType
 */
$do = new \ServiceType\_Do($options);
$do->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for doManifest operation/method
 */
if ($do->doManifest(new \StructType\DoManifestRequest()) !== false) {
    print_r($do->getResult());
} else {
    print_r($do->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for getLabel operation/method
 */
if ($get->getLabel(new \StructType\GetLabelRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVersion operation/method
 */
if ($get->getVersion(new \StructType\Version()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getExportDoc operation/method
 */
if ($get->getExportDoc(new \StructType\GetExportDocRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getManifest operation/method
 */
if ($get->getManifest(new \StructType\GetManifestRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderAuthentification($Authentification);
/**
 * Sample call for updateShipmentOrder operation/method
 */
if ($update->updateShipmentOrder(new \StructType\UpdateShipmentOrderRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
