<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Version StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | The version of the webservice implementation for which the requesting client is developed. | The version of the webservice implementation for which therequesting client is developed.
 * @subpackage Structs
 */
class Version extends AbstractStructBase
{
    /**
     * The majorRelease
     * Meta information extracted from the WSDL
     * - documentation: The number of the major release. E.g. the '3' in version "3.2.".
     * - base: xs:string
     * - maxLength: 2
     * @var string
     */
    public $majorRelease;
    /**
     * The minorRelease
     * Meta information extracted from the WSDL
     * - documentation: The number of the minor release. E.g. the '3' in version "3.2.". | The number of the minor release. E.g. the '2' in version "3.2.".
     * - base: xs:string
     * - maxLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $minorRelease;
    /**
     * The build
     * Meta information extracted from the WSDL
     * - documentation: Optional build id to be addressed.
     * - base: xs:string
     * - maxLength: 5
     * - minOccurs: 0
     * @var string
     */
    public $build;
    /**
     * Constructor method for Version
     * @uses Version::setMajorRelease()
     * @uses Version::setMinorRelease()
     * @uses Version::setBuild()
     * @param string $majorRelease
     * @param string $minorRelease
     * @param string $build
     */
    public function __construct($majorRelease = null, $minorRelease = null, $build = null)
    {
        $this
            ->setMajorRelease($majorRelease)
            ->setMinorRelease($minorRelease)
            ->setBuild($build);
    }
    /**
     * Get majorRelease value
     * @return string|null
     */
    public function getMajorRelease()
    {
        return $this->majorRelease;
    }
    /**
     * Set majorRelease value
     * @param string $majorRelease
     * @return \StructType\Version
     */
    public function setMajorRelease($majorRelease = null)
    {
        // validation for constraint: string
        if (!is_null($majorRelease) && !is_string($majorRelease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($majorRelease, true), gettype($majorRelease)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($majorRelease) && mb_strlen($majorRelease) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($majorRelease)), __LINE__);
        }
        $this->majorRelease = $majorRelease;
        return $this;
    }
    /**
     * Get minorRelease value
     * @return string|null
     */
    public function getMinorRelease()
    {
        return $this->minorRelease;
    }
    /**
     * Set minorRelease value
     * @param string $minorRelease
     * @return \StructType\Version
     */
    public function setMinorRelease($minorRelease = null)
    {
        // validation for constraint: string
        if (!is_null($minorRelease) && !is_string($minorRelease)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minorRelease, true), gettype($minorRelease)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($minorRelease) && mb_strlen($minorRelease) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($minorRelease)), __LINE__);
        }
        $this->minorRelease = $minorRelease;
        return $this;
    }
    /**
     * Get build value
     * @return string|null
     */
    public function getBuild()
    {
        return $this->build;
    }
    /**
     * Set build value
     * @param string $build
     * @return \StructType\Version
     */
    public function setBuild($build = null)
    {
        // validation for constraint: string
        if (!is_null($build) && !is_string($build)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($build, true), gettype($build)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($build) && mb_strlen($build) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($build)), __LINE__);
        }
        $this->build = $build;
        return $this;
    }
}
