<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateShipmentOrderResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and the shipment identifier (if available).
 * @subpackage Structs
 */
class UpdateShipmentOrderResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the overall request.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $shipmentNumber;
    /**
     * The returnShipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $returnShipmentNumber;
    /**
     * The LabelData
     * Meta information extracted from the WSDL
     * - documentation: The operation's success status for every single ShipmentOrder will be returned by one UpdateState element. It is identifiable via ShipmentNumber.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LabelData
     */
    public $LabelData;
    /**
     * Constructor method for UpdateShipmentOrderResponse
     * @uses UpdateShipmentOrderResponse::setVersion()
     * @uses UpdateShipmentOrderResponse::setStatus()
     * @uses UpdateShipmentOrderResponse::setShipmentNumber()
     * @uses UpdateShipmentOrderResponse::setReturnShipmentNumber()
     * @uses UpdateShipmentOrderResponse::setLabelData()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param string $shipmentNumber
     * @param string $returnShipmentNumber
     * @param \StructType\LabelData $labelData
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, $shipmentNumber = null, $returnShipmentNumber = null, \StructType\LabelData $labelData = null)
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setShipmentNumber($shipmentNumber)
            ->setReturnShipmentNumber($returnShipmentNumber)
            ->setLabelData($labelData);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get returnShipmentNumber value
     * @return string|null
     */
    public function getReturnShipmentNumber()
    {
        return $this->returnShipmentNumber;
    }
    /**
     * Set returnShipmentNumber value
     * @param string $returnShipmentNumber
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function setReturnShipmentNumber($returnShipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($returnShipmentNumber) && !is_string($returnShipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnShipmentNumber, true), gettype($returnShipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($returnShipmentNumber) && mb_strlen($returnShipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($returnShipmentNumber)), __LINE__);
        }
        $this->returnShipmentNumber = $returnShipmentNumber;
        return $this;
    }
    /**
     * Get LabelData value
     * @return \StructType\LabelData|null
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }
    /**
     * Set LabelData value
     * @param \StructType\LabelData $labelData
     * @return \StructType\UpdateShipmentOrderResponse
     */
    public function setLabelData(\StructType\LabelData $labelData = null)
    {
        $this->LabelData = $labelData;
        return $this;
    }
}
