<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateShipmentOrderRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The ShipmentNumber of the shipment, which sould be updated. ShipmentNumber is required. This parent element inherits from ShipmentNumberType, therefore all following subelements are valid according to schema, however the web service
 * accepts shipmentNumber only. | The version of the webservice implementation for which the requesting client is developed. | The shipmentdata for creating a shipment.
 * @subpackage Structs
 */
class UpdateShipmentOrderRequest extends AbstractStructBase
{
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The ShipmentOrder
     * Meta information extracted from the WSDL
     * - documentation: ShipmentOrder contains an update of all data of the selected shipment order.
     * @var \StructType\ShipmentOrderType
     */
    public $ShipmentOrder;
    /**
     * The labelResponseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $labelResponseType;
    /**
     * The groupProfileName
     * Meta information extracted from the WSDL
     * - documentation: The group profile you select defines the billing numbers you can use for creating shipments. To define group profiles please visit our business costumer portal. The group profile defines the shipments you can get documents for. The
     * shipment needs to have an account/billing number allocated to the group profile. To define group profiles please visit our business costumer portal. | The group profile you select defines the billing numbers you can use for creating shipments. To
     * define group profiles please visit our business costumer portal.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $groupProfileName;
    /**
     * The labelFormat
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormat;
    /**
     * The labelFormatRetoure
     * Meta information extracted from the WSDL
     * - documentation: In this optional section you can define the following label formats: A4:common label laser printing A4 plain paper; 910-300-700: common label laser printing 105 x 205 mm (910-300-700); 910-300-700-oz: common label laser printing 105
     * x 205 mm without additional barcode labels (910-300-700); 910-300-300: common label laser printing 105 x 148 mm (910-300-700); 910-300-300-oz: common label laser printing 105 x 148 mm without additional barcode labels (910-300-300); 910-300-710:
     * common label laser printing 105 x 208 mm (910-300-710); 910-300-600: common label thermal printing 103 x 199 mm (910-300-600, 910-300-610); 910-300-400: common label thermal printing 103 x 150 mm (910-300-400, 910-300-410); 100x70mm: 100 x 70 mm
     * label (only for Warenpost and Warenpost International);
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $labelFormatRetoure;
    /**
     * The combinedPrinting
     * Meta information extracted from the WSDL
     * - documentation: To get a single PDF for shipping and return label select this option.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $combinedPrinting;
    /**
     * Constructor method for UpdateShipmentOrderRequest
     * @uses UpdateShipmentOrderRequest::setShipmentNumber()
     * @uses UpdateShipmentOrderRequest::setVersion()
     * @uses UpdateShipmentOrderRequest::setShipmentOrder()
     * @uses UpdateShipmentOrderRequest::setLabelResponseType()
     * @uses UpdateShipmentOrderRequest::setGroupProfileName()
     * @uses UpdateShipmentOrderRequest::setLabelFormat()
     * @uses UpdateShipmentOrderRequest::setLabelFormatRetoure()
     * @uses UpdateShipmentOrderRequest::setCombinedPrinting()
     * @param string $shipmentNumber
     * @param \StructType\Version $version
     * @param \StructType\ShipmentOrderType $shipmentOrder
     * @param string $labelResponseType
     * @param string $groupProfileName
     * @param string $labelFormat
     * @param string $labelFormatRetoure
     * @param string $combinedPrinting
     */
    public function __construct($shipmentNumber = null, \StructType\Version $version = null, \StructType\ShipmentOrderType $shipmentOrder = null, $labelResponseType = null, $groupProfileName = null, $labelFormat = null, $labelFormatRetoure = null, $combinedPrinting = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber)
            ->setVersion($version)
            ->setShipmentOrder($shipmentOrder)
            ->setLabelResponseType($labelResponseType)
            ->setGroupProfileName($groupProfileName)
            ->setLabelFormat($labelFormat)
            ->setLabelFormatRetoure($labelFormatRetoure)
            ->setCombinedPrinting($combinedPrinting);
    }
    /**
     * Get shipmentNumber value
     * @return string
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * Set shipmentNumber value
     * @param string $shipmentNumber
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ShipmentOrder value
     * @return \StructType\ShipmentOrderType|null
     */
    public function getShipmentOrder()
    {
        return $this->ShipmentOrder;
    }
    /**
     * Set ShipmentOrder value
     * @param \StructType\ShipmentOrderType $shipmentOrder
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setShipmentOrder(\StructType\ShipmentOrderType $shipmentOrder = null)
    {
        $this->ShipmentOrder = $shipmentOrder;
        return $this;
    }
    /**
     * Get labelResponseType value
     * @return string|null
     */
    public function getLabelResponseType()
    {
        return $this->labelResponseType;
    }
    /**
     * Set labelResponseType value
     * @uses \EnumType\LabelResponseType::valueIsValid()
     * @uses \EnumType\LabelResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $labelResponseType
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setLabelResponseType($labelResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LabelResponseType::valueIsValid($labelResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\LabelResponseType', is_array($labelResponseType) ? implode(', ', $labelResponseType) : var_export($labelResponseType, true), implode(', ', \EnumType\LabelResponseType::getValidValues())), __LINE__);
        }
        $this->labelResponseType = $labelResponseType;
        return $this;
    }
    /**
     * Get groupProfileName value
     * @return string|null
     */
    public function getGroupProfileName()
    {
        return $this->groupProfileName;
    }
    /**
     * Set groupProfileName value
     * @param string $groupProfileName
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setGroupProfileName($groupProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileName) && !is_string($groupProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileName, true), gettype($groupProfileName)), __LINE__);
        }
        $this->groupProfileName = $groupProfileName;
        return $this;
    }
    /**
     * Get labelFormat value
     * @return string|null
     */
    public function getLabelFormat()
    {
        return $this->labelFormat;
    }
    /**
     * Set labelFormat value
     * @param string $labelFormat
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setLabelFormat($labelFormat = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormat) && !is_string($labelFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormat, true), gettype($labelFormat)), __LINE__);
        }
        $this->labelFormat = $labelFormat;
        return $this;
    }
    /**
     * Get labelFormatRetoure value
     * @return string|null
     */
    public function getLabelFormatRetoure()
    {
        return $this->labelFormatRetoure;
    }
    /**
     * Set labelFormatRetoure value
     * @param string $labelFormatRetoure
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setLabelFormatRetoure($labelFormatRetoure = null)
    {
        // validation for constraint: string
        if (!is_null($labelFormatRetoure) && !is_string($labelFormatRetoure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labelFormatRetoure, true), gettype($labelFormatRetoure)), __LINE__);
        }
        $this->labelFormatRetoure = $labelFormatRetoure;
        return $this;
    }
    /**
     * Get combinedPrinting value
     * @return string|null
     */
    public function getCombinedPrinting()
    {
        return $this->combinedPrinting;
    }
    /**
     * Set combinedPrinting value
     * @param string $combinedPrinting
     * @return \StructType\UpdateShipmentOrderRequest
     */
    public function setCombinedPrinting($combinedPrinting = null)
    {
        // validation for constraint: string
        if (!is_null($combinedPrinting) && !is_string($combinedPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinedPrinting, true), gettype($combinedPrinting)), __LINE__);
        }
        $this->combinedPrinting = $combinedPrinting;
        return $this;
    }
}
