<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusElement StructType
 * @subpackage Structs
 */
class StatusElement extends AbstractStructBase
{
    /**
     * The statusElement
     * Meta information extracted from the WSDL
     * - documentation: Explanation of the statusElement and potential errors. | Explains where the error or warning occured
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusElement;
    /**
     * The statusMessage
     * Meta information extracted from the WSDL
     * - documentation: Explanation of the statusMessage and potential errors. | Explains the details of the error or warning
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $statusMessage;
    /**
     * The statusType
     * Meta information extracted from the WSDL
     * - documentation: Explanation of the statuscode and potential errors.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $statusType;
    /**
     * The errorMessage
     * Meta information extracted from the WSDL
     * - documentation: Success status of processing a particular shipment.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\StatusElement[]
     */
    public $errorMessage;
    /**
     * The warningMessage
     * Meta information extracted from the WSDL
     * - documentation: Success status of processing a particular shipment.
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\StatusElement[]
     */
    public $warningMessage;
    /**
     * Constructor method for StatusElement
     * @uses StatusElement::setStatusElement()
     * @uses StatusElement::setStatusMessage()
     * @uses StatusElement::setStatusType()
     * @uses StatusElement::setErrorMessage()
     * @uses StatusElement::setWarningMessage()
     * @param string $statusElement
     * @param string $statusMessage
     * @param string $statusType
     * @param \StructType\StatusElement[] $errorMessage
     * @param \StructType\StatusElement[] $warningMessage
     */
    public function __construct($statusElement = null, $statusMessage = null, $statusType = null, array $errorMessage = array(), array $warningMessage = array())
    {
        $this
            ->setStatusElement($statusElement)
            ->setStatusMessage($statusMessage)
            ->setStatusType($statusType)
            ->setErrorMessage($errorMessage)
            ->setWarningMessage($warningMessage);
    }
    /**
     * Get statusElement value
     * @return string
     */
    public function getStatusElement()
    {
        return $this->statusElement;
    }
    /**
     * Set statusElement value
     * @param string $statusElement
     * @return \StructType\StatusElement
     */
    public function setStatusElement($statusElement = null)
    {
        // validation for constraint: string
        if (!is_null($statusElement) && !is_string($statusElement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusElement, true), gettype($statusElement)), __LINE__);
        }
        $this->statusElement = $statusElement;
        return $this;
    }
    /**
     * Get statusMessage value
     * @return string
     */
    public function getStatusMessage()
    {
        return $this->statusMessage;
    }
    /**
     * Set statusMessage value
     * @param string $statusMessage
     * @return \StructType\StatusElement
     */
    public function setStatusMessage($statusMessage = null)
    {
        // validation for constraint: string
        if (!is_null($statusMessage) && !is_string($statusMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusMessage, true), gettype($statusMessage)), __LINE__);
        }
        $this->statusMessage = $statusMessage;
        return $this;
    }
    /**
     * Get statusType value
     * @return string|null
     */
    public function getStatusType()
    {
        return $this->statusType;
    }
    /**
     * Set statusType value
     * @param string $statusType
     * @return \StructType\StatusElement
     */
    public function setStatusType($statusType = null)
    {
        // validation for constraint: string
        if (!is_null($statusType) && !is_string($statusType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusType, true), gettype($statusType)), __LINE__);
        }
        $this->statusType = $statusType;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return \StructType\StatusElement[]|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setErrorMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErrorMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorMessageForArrayConstraintsFromSetErrorMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusElementErrorMessageItem) {
            // validation for constraint: itemType
            if (!$statusElementErrorMessageItem instanceof \StructType\StatusElement) {
                $invalidValues[] = is_object($statusElementErrorMessageItem) ? get_class($statusElementErrorMessageItem) : sprintf('%s(%s)', gettype($statusElementErrorMessageItem), var_export($statusElementErrorMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The errorMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set errorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement[] $errorMessage
     * @return \StructType\StatusElement
     */
    public function setErrorMessage(array $errorMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($errorMessageArrayErrorMessage = self::validateErrorMessageForArrayConstraintsFromSetErrorMessage($errorMessage))) {
            throw new \InvalidArgumentException($errorMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($errorMessage) && count($errorMessage) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Add item to errorMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement $item
     * @return \StructType\StatusElement
     */
    public function addToErrorMessage(\StructType\StatusElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusElement) {
            throw new \InvalidArgumentException(sprintf('The errorMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->errorMessage) && count($this->errorMessage) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->errorMessage)), __LINE__);
        }
        $this->errorMessage[] = $item;
        return $this;
    }
    /**
     * Get warningMessage value
     * @return \StructType\StatusElement[]|null
     */
    public function getWarningMessage()
    {
        return $this->warningMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setWarningMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWarningMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWarningMessageForArrayConstraintsFromSetWarningMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $statusElementWarningMessageItem) {
            // validation for constraint: itemType
            if (!$statusElementWarningMessageItem instanceof \StructType\StatusElement) {
                $invalidValues[] = is_object($statusElementWarningMessageItem) ? get_class($statusElementWarningMessageItem) : sprintf('%s(%s)', gettype($statusElementWarningMessageItem), var_export($statusElementWarningMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The warningMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set warningMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement[] $warningMessage
     * @return \StructType\StatusElement
     */
    public function setWarningMessage(array $warningMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($warningMessageArrayErrorMessage = self::validateWarningMessageForArrayConstraintsFromSetWarningMessage($warningMessage))) {
            throw new \InvalidArgumentException($warningMessageArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($warningMessage) && count($warningMessage) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($warningMessage)), __LINE__);
        }
        $this->warningMessage = $warningMessage;
        return $this;
    }
    /**
     * Add item to warningMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\StatusElement $item
     * @return \StructType\StatusElement
     */
    public function addToWarningMessage(\StructType\StatusElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StatusElement) {
            throw new \InvalidArgumentException(sprintf('The warningMessage property can only contain items of type \StructType\StatusElement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->warningMessage) && count($this->warningMessage) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->warningMessage)), __LINE__);
        }
        $this->warningMessage[] = $item;
        return $this;
    }
}
