<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentNumberType StructType
 * Meta information extracted from the WSDL
 * - documentation: can be | Type of shipment number
 * @subpackage Structs
 */
class ShipmentNumberType extends AbstractStructBase
{
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - choice: shipmentNumber
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 39
     * - ref: cis:shipmentNumber
     * @var string
     */
    public $shipmentNumber;
    /**
     * Constructor method for ShipmentNumberType
     * @uses ShipmentNumberType::setShipmentNumber()
     * @param string $shipmentNumber
     */
    public function __construct($shipmentNumber = null)
    {
        $this
            ->setShipmentNumber($shipmentNumber);
    }
    /**
     * Get shipmentNumber value
     * @return string|null
     */
    public function getShipmentNumber()
    {
        return isset($this->shipmentNumber) ? $this->shipmentNumber : null;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShipmentNumberForChoiceConstraintsFromSetShipmentNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property shipmentNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: shipmentNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set shipmentNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $shipmentNumber
     * @return \StructType\ShipmentNumberType
     */
    public function setShipmentNumber($shipmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($shipmentNumber) && !is_string($shipmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shipmentNumber, true), gettype($shipmentNumber)), __LINE__);
        }
        // validation for constraint: choice(shipmentNumber)
        if ('' !== ($shipmentNumberChoiceErrorMessage = self::validateShipmentNumberForChoiceConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (!is_null($shipmentNumber) && mb_strlen($shipmentNumber) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($shipmentNumber)), __LINE__);
        }
        if (is_null($shipmentNumber) || (is_array($shipmentNumber) && empty($shipmentNumber))) {
            unset($this->shipmentNumber);
        } else {
            $this->shipmentNumber = $shipmentNumber;
        }
        return $this;
    }
}
