<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipmentDetailsTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: extends the ShipmentDetailsType | Details of a shipment.
 * @subpackage Structs
 */
class ShipmentDetailsTypeType extends ShipmentDetailsType
{
    /**
     * The ShipmentItem
     * Meta information extracted from the WSDL
     * - documentation: For every parcel specified, contains weight in kg, length in cm, width in cm and height in cm.
     * - maxOccurs: 1
     * @var \StructType\ShipmentItemType
     */
    public $ShipmentItem;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - documentation: Use one dedicated Service node for each service to be booked with the shipment product. Add another Service node for booking a further service and so on. Successful booking of a particular service depends on account permissions and
     * product's service combinatorics. I.e. not every service is allowed for every product, or can be combined with all other allowed services. The service bundles that contain all services are the following.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipmentService
     */
    public $Service;
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - documentation: Mechanism to send notifications by email after successful manifesting of shipment.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShipmentNotificationType
     */
    public $Notification;
    /**
     * The BankData
     * Meta information extracted from the WSDL
     * - documentation: Bank data can be provided here for different purposes. E.g. if COD is booked as service, bank data must be provided by DHL customer (mandatory server logic). The collected money will be transferred to specified bank account.
     * - minOccurs: 0
     * @var \StructType\BankType
     */
    public $BankData;
    /**
     * Constructor method for ShipmentDetailsTypeType
     * @uses ShipmentDetailsTypeType::setShipmentItem()
     * @uses ShipmentDetailsTypeType::setService()
     * @uses ShipmentDetailsTypeType::setNotification()
     * @uses ShipmentDetailsTypeType::setBankData()
     * @param \StructType\ShipmentItemType $shipmentItem
     * @param \StructType\ShipmentService $service
     * @param \StructType\ShipmentNotificationType $notification
     * @param \StructType\BankType $bankData
     */
    public function __construct(\StructType\ShipmentItemType $shipmentItem = null, \StructType\ShipmentService $service = null, \StructType\ShipmentNotificationType $notification = null, \StructType\BankType $bankData = null)
    {
        $this
            ->setShipmentItem($shipmentItem)
            ->setService($service)
            ->setNotification($notification)
            ->setBankData($bankData);
    }
    /**
     * Get ShipmentItem value
     * @return \StructType\ShipmentItemType|null
     */
    public function getShipmentItem()
    {
        return $this->ShipmentItem;
    }
    /**
     * Set ShipmentItem value
     * @param \StructType\ShipmentItemType $shipmentItem
     * @return \StructType\ShipmentDetailsTypeType
     */
    public function setShipmentItem(\StructType\ShipmentItemType $shipmentItem = null)
    {
        $this->ShipmentItem = $shipmentItem;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\ShipmentService|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param \StructType\ShipmentService $service
     * @return \StructType\ShipmentDetailsTypeType
     */
    public function setService(\StructType\ShipmentService $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get Notification value
     * @return \StructType\ShipmentNotificationType|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * Set Notification value
     * @param \StructType\ShipmentNotificationType $notification
     * @return \StructType\ShipmentDetailsTypeType
     */
    public function setNotification(\StructType\ShipmentNotificationType $notification = null)
    {
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Get BankData value
     * @return \StructType\BankType|null
     */
    public function getBankData()
    {
        return $this->BankData;
    }
    /**
     * Set BankData value
     * @param \StructType\BankType $bankData
     * @return \StructType\ShipmentDetailsTypeType
     */
    public function setBankData(\StructType\BankType $bankData = null)
    {
        $this->BankData = $bankData;
        return $this;
    }
}
