<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationVisualAgeCheck StructType
 * @subpackage Structs
 */
class ServiceconfigurationVisualAgeCheck extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $type;
    /**
     * Constructor method for ServiceconfigurationVisualAgeCheck
     * @uses ServiceconfigurationVisualAgeCheck::setActive()
     * @uses ServiceconfigurationVisualAgeCheck::setType()
     * @param string $active
     * @param string $type
     */
    public function __construct($active = null, $type = null)
    {
        $this
            ->setActive($active)
            ->setType($type);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationVisualAgeCheck
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\ServiceconfigurationVisualAgeCheck
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($type) && mb_strlen($type) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($type)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($type) && mb_strlen($type) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
