<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationISR StructType
 * @subpackage Structs
 */
class ServiceconfigurationISR extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The details
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $details;
    /**
     * Constructor method for ServiceconfigurationISR
     * @uses ServiceconfigurationISR::setActive()
     * @uses ServiceconfigurationISR::setDetails()
     * @param string $active
     * @param string $details
     */
    public function __construct($active = null, $details = null)
    {
        $this
            ->setActive($active)
            ->setDetails($details);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationISR
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get details value
     * @return string
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param string $details
     * @return \StructType\ServiceconfigurationISR
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($details) && mb_strlen($details) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($details)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($details) && mb_strlen($details) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($details)), __LINE__);
        }
        $this->details = $details;
        return $this;
    }
}
