<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationDetailsResponse StructType
 * @subpackage Structs
 */
class ServiceconfigurationDetailsResponse extends AbstractStructBase
{
    /**
     * The details
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxLength: 100
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $details;
    /**
     * Constructor method for ServiceconfigurationDetailsResponse
     * @uses ServiceconfigurationDetailsResponse::setDetails()
     * @param string $details
     */
    public function __construct($details = null)
    {
        $this
            ->setDetails($details);
    }
    /**
     * Get details value
     * @return string
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * Set details value
     * @param string $details
     * @return \StructType\ServiceconfigurationDetailsResponse
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($details) && mb_strlen($details) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($details)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($details) && mb_strlen($details) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($details)), __LINE__);
        }
        $this->details = $details;
        return $this;
    }
}
