<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceconfigurationAdditionalInsurance StructType
 * @subpackage Structs
 */
class ServiceconfigurationAdditionalInsurance extends AbstractStructBase
{
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $active;
    /**
     * The insuranceAmount
     * Meta information extracted from the WSDL
     * - base: xs:decimal
     * - maxInclusive: 9999999999
     * - minInclusive: 0.0
     * - use: required
     * @var float
     */
    public $insuranceAmount;
    /**
     * Constructor method for ServiceconfigurationAdditionalInsurance
     * @uses ServiceconfigurationAdditionalInsurance::setActive()
     * @uses ServiceconfigurationAdditionalInsurance::setInsuranceAmount()
     * @param string $active
     * @param float $insuranceAmount
     */
    public function __construct($active = null, $insuranceAmount = null)
    {
        $this
            ->setActive($active)
            ->setInsuranceAmount($insuranceAmount);
    }
    /**
     * Get active value
     * @return string
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param string $active
     * @return \StructType\ServiceconfigurationAdditionalInsurance
     */
    public function setActive($active = null)
    {
        // validation for constraint: string
        if (!is_null($active) && !is_string($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get insuranceAmount value
     * @return float
     */
    public function getInsuranceAmount()
    {
        return $this->insuranceAmount;
    }
    /**
     * Set insuranceAmount value
     * @param float $insuranceAmount
     * @return \StructType\ServiceconfigurationAdditionalInsurance
     */
    public function setInsuranceAmount($insuranceAmount = null)
    {
        // validation for constraint: float
        if (!is_null($insuranceAmount) && !(is_float($insuranceAmount) || is_numeric($insuranceAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($insuranceAmount, true), gettype($insuranceAmount)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999)
        if (!is_null($insuranceAmount) && $insuranceAmount > 9999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999', var_export($insuranceAmount, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($insuranceAmount) && $insuranceAmount < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($insuranceAmount, true)), __LINE__);
        }
        $this->insuranceAmount = $insuranceAmount;
        return $this;
    }
}
