<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PickupBookingInformationType StructType
 * Meta information extracted from the WSDL
 * - documentation: The data of the pickup order.
 * @subpackage Structs
 */
class PickupBookingInformationType extends AbstractStructBase
{
    /**
     * The Account
     * Meta information extracted from the WSDL
     * - documentation: Depending on whether a DD pickup or TD pickup is invoked, this field contains either the 10-digit EKP number (DD pickups) or the 9-digit accountNumberExpress (TD pickups).
     * - base: string
     * - maxLength: 14
     * @var string
     */
    public $Account;
    /**
     * The PickupDate
     * Meta information extracted from the WSDL
     * - documentation: Pickup date in format yyyy-mm-dd. Mandatory if pickup is booked along with shipment order. | Pickup date in format yyyy-mm-dd.
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 10
     * @var string
     */
    public $PickupDate;
    /**
     * The ReadyByTime
     * Meta information extracted from the WSDL
     * - documentation: Earliest time for pickup. Format is hh:mm.
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $ReadyByTime;
    /**
     * The ClosingTime
     * Meta information extracted from the WSDL
     * - documentation: Lates time for pickup. Format is hh:mm.
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * @var string
     */
    public $ClosingTime;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Remarks to be considered when pickup is done. Mandatory if 'TDI' is selected.
     * - minOccurs: 0
     * @var string
     */
    public $Remark;
    /**
     * The PickupLocation
     * Meta information extracted from the WSDL
     * - documentation: Area to further detail pickup location beyond address. Mandatory for TDN and TDI, optional for DDN and DDI.
     * - minOccurs: 0
     * @var string
     */
    public $PickupLocation;
    /**
     * The AmountOfPieces
     * Meta information extracted from the WSDL
     * - documentation: Number of pieces to be picked up.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $AmountOfPieces;
    /**
     * The AmountOfPallets
     * Meta information extracted from the WSDL
     * - documentation: Number of pallets to be picked up.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $AmountOfPallets;
    /**
     * The WeightInKG
     * Meta information extracted from the WSDL
     * - documentation: The weight of all shipment's pieces in kg. Field length must be less than or equal to 22.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $WeightInKG;
    /**
     * The CountOfShipments
     * Meta information extracted from the WSDL
     * - documentation: Number of shipments to be picked up.
     * - base: xs:integer
     * - minInclusive: 0
     * - minOccurs: 0
     * @var int
     */
    public $CountOfShipments;
    /**
     * The TotalVolumeWeight
     * Meta information extracted from the WSDL
     * - documentation: The total volumetric weight of all pieces in kg. Calculated by piece = length x width x height in centimetres / 5000. Field length must be less than or equal to 22.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $TotalVolumeWeight;
    /**
     * The MaxLengthInCM
     * Meta information extracted from the WSDL
     * - documentation: The maximum length in cm.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $MaxLengthInCM;
    /**
     * The MaxWidthInCM
     * Meta information extracted from the WSDL
     * - documentation: The maximum width in cm.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $MaxWidthInCM;
    /**
     * The MaxHeightInCM
     * Meta information extracted from the WSDL
     * - documentation: The maximum height in cm.
     * - base: xs:decimal
     * - fractionDigits: 2
     * - maxInclusive: 9999999.99
     * - minInclusive: 0.0
     * - minOccurs: 0
     * @var float
     */
    public $MaxHeightInCM;
    /**
     * Constructor method for PickupBookingInformationType
     * @uses PickupBookingInformationType::setAccount()
     * @uses PickupBookingInformationType::setPickupDate()
     * @uses PickupBookingInformationType::setReadyByTime()
     * @uses PickupBookingInformationType::setClosingTime()
     * @uses PickupBookingInformationType::setRemark()
     * @uses PickupBookingInformationType::setPickupLocation()
     * @uses PickupBookingInformationType::setAmountOfPieces()
     * @uses PickupBookingInformationType::setAmountOfPallets()
     * @uses PickupBookingInformationType::setWeightInKG()
     * @uses PickupBookingInformationType::setCountOfShipments()
     * @uses PickupBookingInformationType::setTotalVolumeWeight()
     * @uses PickupBookingInformationType::setMaxLengthInCM()
     * @uses PickupBookingInformationType::setMaxWidthInCM()
     * @uses PickupBookingInformationType::setMaxHeightInCM()
     * @param string $account
     * @param string $pickupDate
     * @param string $readyByTime
     * @param string $closingTime
     * @param string $remark
     * @param string $pickupLocation
     * @param int $amountOfPieces
     * @param int $amountOfPallets
     * @param float $weightInKG
     * @param int $countOfShipments
     * @param float $totalVolumeWeight
     * @param float $maxLengthInCM
     * @param float $maxWidthInCM
     * @param float $maxHeightInCM
     */
    public function __construct($account = null, $pickupDate = null, $readyByTime = null, $closingTime = null, $remark = null, $pickupLocation = null, $amountOfPieces = null, $amountOfPallets = null, $weightInKG = null, $countOfShipments = null, $totalVolumeWeight = null, $maxLengthInCM = null, $maxWidthInCM = null, $maxHeightInCM = null)
    {
        $this
            ->setAccount($account)
            ->setPickupDate($pickupDate)
            ->setReadyByTime($readyByTime)
            ->setClosingTime($closingTime)
            ->setRemark($remark)
            ->setPickupLocation($pickupLocation)
            ->setAmountOfPieces($amountOfPieces)
            ->setAmountOfPallets($amountOfPallets)
            ->setWeightInKG($weightInKG)
            ->setCountOfShipments($countOfShipments)
            ->setTotalVolumeWeight($totalVolumeWeight)
            ->setMaxLengthInCM($maxLengthInCM)
            ->setMaxWidthInCM($maxWidthInCM)
            ->setMaxHeightInCM($maxHeightInCM);
    }
    /**
     * Get Account value
     * @return string|null
     */
    public function getAccount()
    {
        return $this->Account;
    }
    /**
     * Set Account value
     * @param string $account
     * @return \StructType\PickupBookingInformationType
     */
    public function setAccount($account = null)
    {
        // validation for constraint: string
        if (!is_null($account) && !is_string($account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($account, true), gettype($account)), __LINE__);
        }
        // validation for constraint: maxLength(14)
        if (!is_null($account) && mb_strlen($account) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 14', mb_strlen($account)), __LINE__);
        }
        $this->Account = $account;
        return $this;
    }
    /**
     * Get PickupDate value
     * @return string|null
     */
    public function getPickupDate()
    {
        return $this->PickupDate;
    }
    /**
     * Set PickupDate value
     * @param string $pickupDate
     * @return \StructType\PickupBookingInformationType
     */
    public function setPickupDate($pickupDate = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDate) && !is_string($pickupDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDate, true), gettype($pickupDate)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pickupDate) && mb_strlen($pickupDate) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pickupDate)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($pickupDate) && mb_strlen($pickupDate) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($pickupDate)), __LINE__);
        }
        $this->PickupDate = $pickupDate;
        return $this;
    }
    /**
     * Get ReadyByTime value
     * @return string|null
     */
    public function getReadyByTime()
    {
        return $this->ReadyByTime;
    }
    /**
     * Set ReadyByTime value
     * @param string $readyByTime
     * @return \StructType\PickupBookingInformationType
     */
    public function setReadyByTime($readyByTime = null)
    {
        // validation for constraint: string
        if (!is_null($readyByTime) && !is_string($readyByTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($readyByTime, true), gettype($readyByTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($readyByTime) && mb_strlen($readyByTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($readyByTime)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($readyByTime) && mb_strlen($readyByTime) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($readyByTime)), __LINE__);
        }
        $this->ReadyByTime = $readyByTime;
        return $this;
    }
    /**
     * Get ClosingTime value
     * @return string|null
     */
    public function getClosingTime()
    {
        return $this->ClosingTime;
    }
    /**
     * Set ClosingTime value
     * @param string $closingTime
     * @return \StructType\PickupBookingInformationType
     */
    public function setClosingTime($closingTime = null)
    {
        // validation for constraint: string
        if (!is_null($closingTime) && !is_string($closingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingTime, true), gettype($closingTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($closingTime) && mb_strlen($closingTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($closingTime)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($closingTime) && mb_strlen($closingTime) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($closingTime)), __LINE__);
        }
        $this->ClosingTime = $closingTime;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\PickupBookingInformationType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Get PickupLocation value
     * @return string|null
     */
    public function getPickupLocation()
    {
        return $this->PickupLocation;
    }
    /**
     * Set PickupLocation value
     * @param string $pickupLocation
     * @return \StructType\PickupBookingInformationType
     */
    public function setPickupLocation($pickupLocation = null)
    {
        // validation for constraint: string
        if (!is_null($pickupLocation) && !is_string($pickupLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupLocation, true), gettype($pickupLocation)), __LINE__);
        }
        $this->PickupLocation = $pickupLocation;
        return $this;
    }
    /**
     * Get AmountOfPieces value
     * @return int|null
     */
    public function getAmountOfPieces()
    {
        return $this->AmountOfPieces;
    }
    /**
     * Set AmountOfPieces value
     * @param int $amountOfPieces
     * @return \StructType\PickupBookingInformationType
     */
    public function setAmountOfPieces($amountOfPieces = null)
    {
        // validation for constraint: int
        if (!is_null($amountOfPieces) && !(is_int($amountOfPieces) || ctype_digit($amountOfPieces))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountOfPieces, true), gettype($amountOfPieces)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amountOfPieces) && $amountOfPieces < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amountOfPieces, true)), __LINE__);
        }
        $this->AmountOfPieces = $amountOfPieces;
        return $this;
    }
    /**
     * Get AmountOfPallets value
     * @return int|null
     */
    public function getAmountOfPallets()
    {
        return $this->AmountOfPallets;
    }
    /**
     * Set AmountOfPallets value
     * @param int $amountOfPallets
     * @return \StructType\PickupBookingInformationType
     */
    public function setAmountOfPallets($amountOfPallets = null)
    {
        // validation for constraint: int
        if (!is_null($amountOfPallets) && !(is_int($amountOfPallets) || ctype_digit($amountOfPallets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($amountOfPallets, true), gettype($amountOfPallets)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($amountOfPallets) && $amountOfPallets < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($amountOfPallets, true)), __LINE__);
        }
        $this->AmountOfPallets = $amountOfPallets;
        return $this;
    }
    /**
     * Get WeightInKG value
     * @return float|null
     */
    public function getWeightInKG()
    {
        return $this->WeightInKG;
    }
    /**
     * Set WeightInKG value
     * @param float $weightInKG
     * @return \StructType\PickupBookingInformationType
     */
    public function setWeightInKG($weightInKG = null)
    {
        // validation for constraint: float
        if (!is_null($weightInKG) && !(is_float($weightInKG) || is_numeric($weightInKG))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weightInKG, true), gettype($weightInKG)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($weightInKG) && mb_strlen(mb_substr($weightInKG, false !== mb_strpos($weightInKG, '.') ? mb_strpos($weightInKG, '.') + 1 : mb_strlen($weightInKG))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($weightInKG, true), mb_strlen(mb_substr($weightInKG, mb_strpos($weightInKG, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($weightInKG) && $weightInKG > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($weightInKG, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($weightInKG) && $weightInKG < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($weightInKG, true)), __LINE__);
        }
        $this->WeightInKG = $weightInKG;
        return $this;
    }
    /**
     * Get CountOfShipments value
     * @return int|null
     */
    public function getCountOfShipments()
    {
        return $this->CountOfShipments;
    }
    /**
     * Set CountOfShipments value
     * @param int $countOfShipments
     * @return \StructType\PickupBookingInformationType
     */
    public function setCountOfShipments($countOfShipments = null)
    {
        // validation for constraint: int
        if (!is_null($countOfShipments) && !(is_int($countOfShipments) || ctype_digit($countOfShipments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countOfShipments, true), gettype($countOfShipments)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($countOfShipments) && $countOfShipments < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($countOfShipments, true)), __LINE__);
        }
        $this->CountOfShipments = $countOfShipments;
        return $this;
    }
    /**
     * Get TotalVolumeWeight value
     * @return float|null
     */
    public function getTotalVolumeWeight()
    {
        return $this->TotalVolumeWeight;
    }
    /**
     * Set TotalVolumeWeight value
     * @param float $totalVolumeWeight
     * @return \StructType\PickupBookingInformationType
     */
    public function setTotalVolumeWeight($totalVolumeWeight = null)
    {
        // validation for constraint: float
        if (!is_null($totalVolumeWeight) && !(is_float($totalVolumeWeight) || is_numeric($totalVolumeWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalVolumeWeight, true), gettype($totalVolumeWeight)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($totalVolumeWeight) && mb_strlen(mb_substr($totalVolumeWeight, false !== mb_strpos($totalVolumeWeight, '.') ? mb_strpos($totalVolumeWeight, '.') + 1 : mb_strlen($totalVolumeWeight))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($totalVolumeWeight, true), mb_strlen(mb_substr($totalVolumeWeight, mb_strpos($totalVolumeWeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($totalVolumeWeight) && $totalVolumeWeight > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($totalVolumeWeight, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($totalVolumeWeight) && $totalVolumeWeight < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($totalVolumeWeight, true)), __LINE__);
        }
        $this->TotalVolumeWeight = $totalVolumeWeight;
        return $this;
    }
    /**
     * Get MaxLengthInCM value
     * @return float|null
     */
    public function getMaxLengthInCM()
    {
        return $this->MaxLengthInCM;
    }
    /**
     * Set MaxLengthInCM value
     * @param float $maxLengthInCM
     * @return \StructType\PickupBookingInformationType
     */
    public function setMaxLengthInCM($maxLengthInCM = null)
    {
        // validation for constraint: float
        if (!is_null($maxLengthInCM) && !(is_float($maxLengthInCM) || is_numeric($maxLengthInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxLengthInCM, true), gettype($maxLengthInCM)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($maxLengthInCM) && mb_strlen(mb_substr($maxLengthInCM, false !== mb_strpos($maxLengthInCM, '.') ? mb_strpos($maxLengthInCM, '.') + 1 : mb_strlen($maxLengthInCM))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($maxLengthInCM, true), mb_strlen(mb_substr($maxLengthInCM, mb_strpos($maxLengthInCM, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($maxLengthInCM) && $maxLengthInCM > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($maxLengthInCM, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($maxLengthInCM) && $maxLengthInCM < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($maxLengthInCM, true)), __LINE__);
        }
        $this->MaxLengthInCM = $maxLengthInCM;
        return $this;
    }
    /**
     * Get MaxWidthInCM value
     * @return float|null
     */
    public function getMaxWidthInCM()
    {
        return $this->MaxWidthInCM;
    }
    /**
     * Set MaxWidthInCM value
     * @param float $maxWidthInCM
     * @return \StructType\PickupBookingInformationType
     */
    public function setMaxWidthInCM($maxWidthInCM = null)
    {
        // validation for constraint: float
        if (!is_null($maxWidthInCM) && !(is_float($maxWidthInCM) || is_numeric($maxWidthInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxWidthInCM, true), gettype($maxWidthInCM)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($maxWidthInCM) && mb_strlen(mb_substr($maxWidthInCM, false !== mb_strpos($maxWidthInCM, '.') ? mb_strpos($maxWidthInCM, '.') + 1 : mb_strlen($maxWidthInCM))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($maxWidthInCM, true), mb_strlen(mb_substr($maxWidthInCM, mb_strpos($maxWidthInCM, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($maxWidthInCM) && $maxWidthInCM > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($maxWidthInCM, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($maxWidthInCM) && $maxWidthInCM < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($maxWidthInCM, true)), __LINE__);
        }
        $this->MaxWidthInCM = $maxWidthInCM;
        return $this;
    }
    /**
     * Get MaxHeightInCM value
     * @return float|null
     */
    public function getMaxHeightInCM()
    {
        return $this->MaxHeightInCM;
    }
    /**
     * Set MaxHeightInCM value
     * @param float $maxHeightInCM
     * @return \StructType\PickupBookingInformationType
     */
    public function setMaxHeightInCM($maxHeightInCM = null)
    {
        // validation for constraint: float
        if (!is_null($maxHeightInCM) && !(is_float($maxHeightInCM) || is_numeric($maxHeightInCM))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maxHeightInCM, true), gettype($maxHeightInCM)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($maxHeightInCM) && mb_strlen(mb_substr($maxHeightInCM, false !== mb_strpos($maxHeightInCM, '.') ? mb_strpos($maxHeightInCM, '.') + 1 : mb_strlen($maxHeightInCM))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($maxHeightInCM, true), mb_strlen(mb_substr($maxHeightInCM, mb_strpos($maxHeightInCM, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999.99)
        if (!is_null($maxHeightInCM) && $maxHeightInCM > 9999999.99) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999.99', var_export($maxHeightInCM, true)), __LINE__);
        }
        // validation for constraint: minInclusive(0.0)
        if (!is_null($maxHeightInCM) && $maxHeightInCM < 0.0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0.0', var_export($maxHeightInCM, true)), __LINE__);
        }
        $this->MaxHeightInCM = $maxHeightInCM;
        return $this;
    }
}
