<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentityCard StructType
 * Meta information extracted from the WSDL
 * - documentation: If identity card shall be used for verifying identity.
 * @subpackage Structs
 */
class IdentityCard extends AbstractStructBase
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - documentation: Number of the identity card. Mandatory if IdentityCard is chosen as identity instrument. Field length must be less than or equal to 20.
     * @var string
     */
    public $CardNumber;
    /**
     * The CardAuthority
     * Meta information extracted from the WSDL
     * - documentation: Name of certifying card authority. Mandatory if IdentityCard is chosen as identity instrument. Field length must be less than or equal to 30.
     * @var string
     */
    public $CardAuthority;
    /**
     * Constructor method for IdentityCard
     * @uses IdentityCard::setCardNumber()
     * @uses IdentityCard::setCardAuthority()
     * @param string $cardNumber
     * @param string $cardAuthority
     */
    public function __construct($cardNumber = null, $cardAuthority = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardAuthority($cardAuthority);
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \StructType\IdentityCard
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get CardAuthority value
     * @return string|null
     */
    public function getCardAuthority()
    {
        return $this->CardAuthority;
    }
    /**
     * Set CardAuthority value
     * @param string $cardAuthority
     * @return \StructType\IdentityCard
     */
    public function setCardAuthority($cardAuthority = null)
    {
        // validation for constraint: string
        if (!is_null($cardAuthority) && !is_string($cardAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardAuthority, true), gettype($cardAuthority)), __LINE__);
        }
        $this->CardAuthority = $cardAuthority;
        return $this;
    }
}
