<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ident StructType
 * Meta information extracted from the WSDL
 * - documentation: Identity data (used for ident services).
 * @subpackage Structs
 */
class Ident extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: First name of the person to be verified. Field length must be less than or equal to 30.
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Last name of the person to be verified. Field length must be less than or equal to 30.
     * @var string
     */
    public $LastName;
    /**
     * The Street
     * Meta information extracted from the WSDL
     * - documentation: Name of the street of registered address. Field length must be less than or equal to 30.
     * @var string
     */
    public $Street;
    /**
     * The HouseNumber
     * Meta information extracted from the WSDL
     * - documentation: House number of registered address. Field length must be less than or equal to 10.
     * @var string
     */
    public $HouseNumber;
    /**
     * The Postcode
     * Meta information extracted from the WSDL
     * - documentation: Postcode of registered address. Field length must be less than or equal to 15.
     * @var string
     */
    public $Postcode;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - documentation: City of registered address. Field length must be less than or equal to 30.
     * @var string
     */
    public $City;
    /**
     * The DateOfBirth
     * Meta information extracted from the WSDL
     * - documentation: Person's date of birth. Format must be yyyy-mm-dd.
     * @var string
     */
    public $DateOfBirth;
    /**
     * The Nationality
     * Meta information extracted from the WSDL
     * - documentation: Person's nationality. Field length must be less than or equal to 30.
     * @var string
     */
    public $Nationality;
    /**
     * The surname
     * Meta information extracted from the WSDL
     * - documentation: Surname (family name) of the person for ident check.
     * - base: xs:string
     * - maxLength: 255
     * - minLength: 0
     * @var string
     */
    public $surname;
    /**
     * The givenName
     * Meta information extracted from the WSDL
     * - documentation: Given name (first name) of the person for ident check.
     * - base: xs:string
     * - maxLength: 255
     * - minLength: 0
     * @var string
     */
    public $givenName;
    /**
     * The dateOfBirth
     * Meta information extracted from the WSDL
     * - documentation: date of birth (DOB) of the person for ident check, if the option is used: Date in format yyyy-mm-dd
     * - base: xs:string
     * - maxLength: 10
     * - minLength: 10
     * @var string
     */
    public $dateOfBirth;
    /**
     * The minimumAge
     * Meta information extracted from the WSDL
     * - documentation: minimum age of the person for ident check ("A16" or "A18")
     * - base: xs:string
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $minimumAge;
    /**
     * Constructor method for Ident
     * @uses Ident::setFirstName()
     * @uses Ident::setLastName()
     * @uses Ident::setStreet()
     * @uses Ident::setHouseNumber()
     * @uses Ident::setPostcode()
     * @uses Ident::setCity()
     * @uses Ident::setDateOfBirth()
     * @uses Ident::setNationality()
     * @uses Ident::setSurname()
     * @uses Ident::setGivenName()
     * @uses Ident::setDateOfBirth_1()
     * @uses Ident::setMinimumAge()
     * @param string $firstName
     * @param string $lastName
     * @param string $street
     * @param string $houseNumber
     * @param string $postcode
     * @param string $city
     * @param string $dateOfBirth
     * @param string $nationality
     * @param string $surname
     * @param string $givenName
     * @param string $dateOfBirth
     * @param string $minimumAge
     */
    public function __construct($firstName = null, $lastName = null, $street = null, $houseNumber = null, $postcode = null, $city = null, $dateOfBirth = null, $nationality = null, $surname = null, $givenName = null, $dateOfBirth_1 = null, $minimumAge = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setStreet($street)
            ->setHouseNumber($houseNumber)
            ->setPostcode($postcode)
            ->setCity($city)
            ->setDateOfBirth($dateOfBirth)
            ->setNationality($nationality)
            ->setSurname($surname)
            ->setGivenName($givenName)
            ->setDateOfBirth_1($dateOfBirth_1)
            ->setMinimumAge($minimumAge);
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\Ident
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \StructType\Ident
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
    /**
     * Get Street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\Ident
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get HouseNumber value
     * @return string|null
     */
    public function getHouseNumber()
    {
        return $this->HouseNumber;
    }
    /**
     * Set HouseNumber value
     * @param string $houseNumber
     * @return \StructType\Ident
     */
    public function setHouseNumber($houseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($houseNumber) && !is_string($houseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseNumber, true), gettype($houseNumber)), __LINE__);
        }
        $this->HouseNumber = $houseNumber;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\Ident
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\Ident
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($city, true), gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->DateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Ident
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth, true), gettype($dateOfBirth)), __LINE__);
        }
        $this->DateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Get Nationality value
     * @return string|null
     */
    public function getNationality()
    {
        return $this->Nationality;
    }
    /**
     * Set Nationality value
     * @param string $nationality
     * @return \StructType\Ident
     */
    public function setNationality($nationality = null)
    {
        // validation for constraint: string
        if (!is_null($nationality) && !is_string($nationality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationality, true), gettype($nationality)), __LINE__);
        }
        $this->Nationality = $nationality;
        return $this;
    }
    /**
     * Get surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->surname;
    }
    /**
     * Set surname value
     * @param string $surname
     * @return \StructType\Ident
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($surname) && mb_strlen($surname) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($surname) && mb_strlen($surname) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($surname)), __LINE__);
        }
        $this->surname = $surname;
        return $this;
    }
    /**
     * Get givenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->givenName;
    }
    /**
     * Set givenName value
     * @param string $givenName
     * @return \StructType\Ident
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($givenName) && mb_strlen($givenName) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($givenName)), __LINE__);
        }
        // validation for constraint: minLength
        if (!is_null($givenName) && mb_strlen($givenName) < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 0', mb_strlen($givenName)), __LINE__);
        }
        $this->givenName = $givenName;
        return $this;
    }
    /**
     * Get DateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth_1()
    {
        return $this->dateOfBirth;
    }
    /**
     * Set DateOfBirth value
     * @param string $dateOfBirth
     * @return \StructType\Ident
     */
    public function setDateOfBirth_1($dateOfBirth_1 = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth_1) && !is_string($dateOfBirth_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfBirth_1, true), gettype($dateOfBirth_1)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($dateOfBirth_1) && mb_strlen($dateOfBirth_1) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($dateOfBirth_1)), __LINE__);
        }
        // validation for constraint: minLength(10)
        if (!is_null($dateOfBirth_1) && mb_strlen($dateOfBirth_1) < 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 10', mb_strlen($dateOfBirth_1)), __LINE__);
        }
        $this->dateOfBirth = $dateOfBirth_1;
        return $this;
    }
    /**
     * Get minimumAge value
     * @return string|null
     */
    public function getMinimumAge()
    {
        return $this->minimumAge;
    }
    /**
     * Set minimumAge value
     * @param string $minimumAge
     * @return \StructType\Ident
     */
    public function setMinimumAge($minimumAge = null)
    {
        // validation for constraint: string
        if (!is_null($minimumAge) && !is_string($minimumAge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumAge, true), gettype($minimumAge)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($minimumAge) && mb_strlen($minimumAge) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($minimumAge)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($minimumAge) && mb_strlen($minimumAge) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($minimumAge)), __LINE__);
        }
        $this->minimumAge = $minimumAge;
        return $this;
    }
}
