<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetManifestResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and requested export document.
 * @subpackage Structs
 */
class GetManifestResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Status of the request (value of zero means, the request was processed without error; value greater than zero indicates that an error occurred).
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The manifestData
     * Meta information extracted from the WSDL
     * - documentation: The Base64 encoded pdf data for receiving the manifest.
     * - minOccurs: 0
     * @var string
     */
    public $manifestData;
    /**
     * Constructor method for GetManifestResponse
     * @uses GetManifestResponse::setVersion()
     * @uses GetManifestResponse::setStatus()
     * @uses GetManifestResponse::setManifestData()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param string $manifestData
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, $manifestData = null)
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setManifestData($manifestData);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetManifestResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\GetManifestResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get manifestData value
     * @return string|null
     */
    public function getManifestData()
    {
        return $this->manifestData;
    }
    /**
     * Set manifestData value
     * @param string $manifestData
     * @return \StructType\GetManifestResponse
     */
    public function setManifestData($manifestData = null)
    {
        // validation for constraint: string
        if (!is_null($manifestData) && !is_string($manifestData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestData, true), gettype($manifestData)), __LINE__);
        }
        $this->manifestData = $manifestData;
        return $this;
    }
}
