<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetManifestRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation for which the requesting client is developed. | The request data for the manifest document
 * @subpackage Structs
 */
class GetManifestRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The manifestDate
     * Meta information extracted from the WSDL
     * - documentation: Date in format yyyy-mm-dd
     * @var string
     */
    public $manifestDate;
    /**
     * Constructor method for GetManifestRequest
     * @uses GetManifestRequest::setVersion()
     * @uses GetManifestRequest::setManifestDate()
     * @param \StructType\Version $version
     * @param string $manifestDate
     */
    public function __construct(\StructType\Version $version = null, $manifestDate = null)
    {
        $this
            ->setVersion($version)
            ->setManifestDate($manifestDate);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetManifestRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get manifestDate value
     * @return string|null
     */
    public function getManifestDate()
    {
        return $this->manifestDate;
    }
    /**
     * Set manifestDate value
     * @param string $manifestDate
     * @return \StructType\GetManifestRequest
     */
    public function setManifestDate($manifestDate = null)
    {
        // validation for constraint: string
        if (!is_null($manifestDate) && !is_string($manifestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manifestDate, true), gettype($manifestDate)), __LINE__);
        }
        $this->manifestDate = $manifestDate;
        return $this;
    }
}
