<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLabelResponse StructType
 * Meta information extracted from the WSDL
 * - documentation: The version of the webservice implementation. | The status of the operation and requested urls for getting the label.
 * @subpackage Structs
 */
class GetLabelResponse extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Success status after processing the overall request.
     * @var \StructType\Statusinformation
     */
    public $Status;
    /**
     * The LabelData
     * Meta information extracted from the WSDL
     * - documentation: For every ShipmentNumber requested, one LabelData node is returned that contains the status of the label retrieval operation and the URL for the label (if available).
     * - maxOccurs: 30
     * - minOccurs: 0
     * @var \StructType\LabelData[]
     */
    public $LabelData;
    /**
     * Constructor method for GetLabelResponse
     * @uses GetLabelResponse::setVersion()
     * @uses GetLabelResponse::setStatus()
     * @uses GetLabelResponse::setLabelData()
     * @param \StructType\Version $version
     * @param \StructType\Statusinformation $status
     * @param \StructType\LabelData[] $labelData
     */
    public function __construct(\StructType\Version $version = null, \StructType\Statusinformation $status = null, array $labelData = array())
    {
        $this
            ->setVersion($version)
            ->setStatus($status)
            ->setLabelData($labelData);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetLabelResponse
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Status value
     * @return \StructType\Statusinformation|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param \StructType\Statusinformation $status
     * @return \StructType\GetLabelResponse
     */
    public function setStatus(\StructType\Statusinformation $status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get LabelData value
     * @return \StructType\LabelData[]|null
     */
    public function getLabelData()
    {
        return $this->LabelData;
    }
    /**
     * This method is responsible for validating the values passed to the setLabelData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLabelData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLabelDataForArrayConstraintsFromSetLabelData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getLabelResponseLabelDataItem) {
            // validation for constraint: itemType
            if (!$getLabelResponseLabelDataItem instanceof \StructType\LabelData) {
                $invalidValues[] = is_object($getLabelResponseLabelDataItem) ? get_class($getLabelResponseLabelDataItem) : sprintf('%s(%s)', gettype($getLabelResponseLabelDataItem), var_export($getLabelResponseLabelDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LabelData property can only contain items of type \StructType\LabelData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LabelData value
     * @throws \InvalidArgumentException
     * @param \StructType\LabelData[] $labelData
     * @return \StructType\GetLabelResponse
     */
    public function setLabelData(array $labelData = array())
    {
        // validation for constraint: array
        if ('' !== ($labelDataArrayErrorMessage = self::validateLabelDataForArrayConstraintsFromSetLabelData($labelData))) {
            throw new \InvalidArgumentException($labelDataArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($labelData) && count($labelData) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($labelData)), __LINE__);
        }
        $this->LabelData = $labelData;
        return $this;
    }
    /**
     * Add item to LabelData value
     * @throws \InvalidArgumentException
     * @param \StructType\LabelData $item
     * @return \StructType\GetLabelResponse
     */
    public function addToLabelData(\StructType\LabelData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LabelData) {
            throw new \InvalidArgumentException(sprintf('The LabelData property can only contain items of type \StructType\LabelData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->LabelData) && count($this->LabelData) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->LabelData)), __LINE__);
        }
        $this->LabelData[] = $item;
        return $this;
    }
}
