<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetExportDocRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: To request export documents, ShipmentNumber. ShipmentNumber is required. This parent element inherits from ShipmentNumberType, therefore all following subelements are valid according to schema, however the web service accepts
 * shipmentNumber only. | The version of the webservice implementation for which the requesting client is developed. | The identifier for the shipment for which the export document url is requested.
 * @subpackage Structs
 */
class GetExportDocRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - maxLength: 39
     * - maxOccurs: 30
     * - ref: cis:shipmentNumber
     * @var string[]
     */
    public $shipmentNumber;
    /**
     * The exportDocResponseType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $exportDocResponseType;
    /**
     * The groupProfileName
     * Meta information extracted from the WSDL
     * - documentation: The group profile you select defines the billing numbers you can use for creating shipments. To define group profiles please visit our business costumer portal. The group profile defines the shipments you can get documents for. The
     * shipment needs to have an account/billing number allocated to the group profile. To define group profiles please visit our business costumer portal. | The group profile you select defines the billing numbers you can use for creating shipments. To
     * define group profiles please visit our business costumer portal.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $groupProfileName;
    /**
     * The combinedPrinting
     * Meta information extracted from the WSDL
     * - documentation: To get a single PDF for shipping and return label select this option.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $combinedPrinting;
    /**
     * Constructor method for GetExportDocRequest
     * @uses GetExportDocRequest::setVersion()
     * @uses GetExportDocRequest::setShipmentNumber()
     * @uses GetExportDocRequest::setExportDocResponseType()
     * @uses GetExportDocRequest::setGroupProfileName()
     * @uses GetExportDocRequest::setCombinedPrinting()
     * @param \StructType\Version $version
     * @param string[] $shipmentNumber
     * @param string $exportDocResponseType
     * @param string $groupProfileName
     * @param string $combinedPrinting
     */
    public function __construct(\StructType\Version $version = null, array $shipmentNumber = array(), $exportDocResponseType = null, $groupProfileName = null, $combinedPrinting = null)
    {
        $this
            ->setVersion($version)
            ->setShipmentNumber($shipmentNumber)
            ->setExportDocResponseType($exportDocResponseType)
            ->setGroupProfileName($groupProfileName)
            ->setCombinedPrinting($combinedPrinting);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\GetExportDocRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string[]|null
     */
    public function getShipmentNumber()
    {
        return $this->shipmentNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForArrayConstraintsFromSetShipmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getExportDocRequestShipmentNumberItem) {
            // validation for constraint: itemType
            if (!is_string($getExportDocRequestShipmentNumberItem)) {
                $invalidValues[] = is_object($getExportDocRequestShipmentNumberItem) ? get_class($getExportDocRequestShipmentNumberItem) : sprintf('%s(%s)', gettype($getExportDocRequestShipmentNumberItem), var_export($getExportDocRequestShipmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getExportDocRequestShipmentNumberItem) {
            // validation for constraint: maxLength(39)
            if (mb_strlen($getExportDocRequestShipmentNumberItem) > 39) {
                $invalidValues[] = var_export($getExportDocRequestShipmentNumberItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 39', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $shipmentNumber
     * @return \StructType\GetExportDocRequest
     */
    public function setShipmentNumber(array $shipmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentNumberArrayErrorMessage = self::validateShipmentNumberForArrayConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if ('' !== ($shipmentNumberMaxLengthErrorMessage = self::validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($shipmentNumber) && count($shipmentNumber) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 30', count($shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber = $shipmentNumber;
        return $this;
    }
    /**
     * Add item to shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetExportDocRequest
     */
    public function addToShipmentNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (mb_strlen($item) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(30)
        if (is_array($this->shipmentNumber) && count($this->shipmentNumber) >= 30) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 30', count($this->shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber[] = $item;
        return $this;
    }
    /**
     * Get exportDocResponseType value
     * @return string|null
     */
    public function getExportDocResponseType()
    {
        return $this->exportDocResponseType;
    }
    /**
     * Set exportDocResponseType value
     * @uses \EnumType\ExportDocResponseType::valueIsValid()
     * @uses \EnumType\ExportDocResponseType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportDocResponseType
     * @return \StructType\GetExportDocRequest
     */
    public function setExportDocResponseType($exportDocResponseType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ExportDocResponseType::valueIsValid($exportDocResponseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ExportDocResponseType', is_array($exportDocResponseType) ? implode(', ', $exportDocResponseType) : var_export($exportDocResponseType, true), implode(', ', \EnumType\ExportDocResponseType::getValidValues())), __LINE__);
        }
        $this->exportDocResponseType = $exportDocResponseType;
        return $this;
    }
    /**
     * Get groupProfileName value
     * @return string|null
     */
    public function getGroupProfileName()
    {
        return $this->groupProfileName;
    }
    /**
     * Set groupProfileName value
     * @param string $groupProfileName
     * @return \StructType\GetExportDocRequest
     */
    public function setGroupProfileName($groupProfileName = null)
    {
        // validation for constraint: string
        if (!is_null($groupProfileName) && !is_string($groupProfileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupProfileName, true), gettype($groupProfileName)), __LINE__);
        }
        $this->groupProfileName = $groupProfileName;
        return $this;
    }
    /**
     * Get combinedPrinting value
     * @return string|null
     */
    public function getCombinedPrinting()
    {
        return $this->combinedPrinting;
    }
    /**
     * Set combinedPrinting value
     * @param string $combinedPrinting
     * @return \StructType\GetExportDocRequest
     */
    public function setCombinedPrinting($combinedPrinting = null)
    {
        // validation for constraint: string
        if (!is_null($combinedPrinting) && !is_string($combinedPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($combinedPrinting, true), gettype($combinedPrinting)), __LINE__);
        }
        $this->combinedPrinting = $combinedPrinting;
        return $this;
    }
}
