<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DrivingLicense StructType
 * Meta information extracted from the WSDL
 * - documentation: If driving license shall be used for verifying identity.
 * @subpackage Structs
 */
class DrivingLicense extends AbstractStructBase
{
    /**
     * The LicenseNumber
     * Meta information extracted from the WSDL
     * - documentation: ID number of the driving license. Mandatory if DrivingLicense is chosen as identity instrument.
     * @var string
     */
    public $LicenseNumber;
    /**
     * The Authority
     * Meta information extracted from the WSDL
     * - documentation: Name of certifying authority of the driving license. Mandatory if DrivingLicense is chosen as identity instrument.
     * @var string
     */
    public $Authority;
    /**
     * Constructor method for DrivingLicense
     * @uses DrivingLicense::setLicenseNumber()
     * @uses DrivingLicense::setAuthority()
     * @param string $licenseNumber
     * @param string $authority
     */
    public function __construct($licenseNumber = null, $authority = null)
    {
        $this
            ->setLicenseNumber($licenseNumber)
            ->setAuthority($authority);
    }
    /**
     * Get LicenseNumber value
     * @return string|null
     */
    public function getLicenseNumber()
    {
        return $this->LicenseNumber;
    }
    /**
     * Set LicenseNumber value
     * @param string $licenseNumber
     * @return \StructType\DrivingLicense
     */
    public function setLicenseNumber($licenseNumber = null)
    {
        // validation for constraint: string
        if (!is_null($licenseNumber) && !is_string($licenseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($licenseNumber, true), gettype($licenseNumber)), __LINE__);
        }
        $this->LicenseNumber = $licenseNumber;
        return $this;
    }
    /**
     * Get Authority value
     * @return string|null
     */
    public function getAuthority()
    {
        return $this->Authority;
    }
    /**
     * Set Authority value
     * @param string $authority
     * @return \StructType\DrivingLicense
     */
    public function setAuthority($authority = null)
    {
        // validation for constraint: string
        if (!is_null($authority) && !is_string($authority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authority, true), gettype($authority)), __LINE__);
        }
        $this->Authority = $authority;
        return $this;
    }
}
