<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoManifestRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains a shipment number. Any number of a printed shipment not already manifested can be used. A Request can contain the element up to 50 times. Requests need to either contain at least one times shipmentNumber or allshipments.
 * Requests cannot contain shipmentNumber and allShipments at the same time. | The version of the webservice implementation for which the requesting client is developed. | Manifests one ore more shipments.
 * @subpackage Structs
 */
class DoManifestRequest extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - ref: bcs:Version
     * @var \StructType\Version
     */
    public $Version;
    /**
     * The shipmentNumber
     * Meta information extracted from the WSDL
     * - documentation: Can contain any DHL shipmentnumber. | Can contain any DHL shipmentnumber. For successful and unsuccessful operations, the requested ShipmentNumber to be deleted is returned. This is no matter if the operation could be performed or
     * not.
     * - base: xs:string
     * - choice: shipmentNumber | allShipments
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 39
     * - maxOccurs: 50
     * - ref: cis:shipmentNumber
     * @var string[]
     */
    public $shipmentNumber;
    /**
     * The allShipments
     * Meta information extracted from the WSDL
     * - choice: shipmentNumber | allShipments
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var mixed
     */
    public $allShipments;
    /**
     * Constructor method for DoManifestRequest
     * @uses DoManifestRequest::setVersion()
     * @uses DoManifestRequest::setShipmentNumber()
     * @uses DoManifestRequest::setAllShipments()
     * @param \StructType\Version $version
     * @param string[] $shipmentNumber
     * @param mixed $allShipments
     */
    public function __construct(\StructType\Version $version = null, array $shipmentNumber = array(), $allShipments = null)
    {
        $this
            ->setVersion($version)
            ->setShipmentNumber($shipmentNumber)
            ->setAllShipments($allShipments);
    }
    /**
     * Get Version value
     * @return \StructType\Version|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param \StructType\Version $version
     * @return \StructType\DoManifestRequest
     */
    public function setVersion(\StructType\Version $version = null)
    {
        $this->Version = $version;
        return $this;
    }
    /**
     * Get shipmentNumber value
     * @return string[]|null
     */
    public function getShipmentNumber()
    {
        return isset($this->shipmentNumber) ? $this->shipmentNumber : null;
    }
    /**
     * This method is responsible for validating the values passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForArrayConstraintsFromSetShipmentNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doManifestRequestShipmentNumberItem) {
            // validation for constraint: itemType
            if (!is_string($doManifestRequestShipmentNumberItem)) {
                $invalidValues[] = is_object($doManifestRequestShipmentNumberItem) ? get_class($doManifestRequestShipmentNumberItem) : sprintf('%s(%s)', gettype($doManifestRequestShipmentNumberItem), var_export($doManifestRequestShipmentNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateShipmentNumberForChoiceConstraintsFromSetShipmentNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'allShipments',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property shipmentNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: shipmentNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setShipmentNumber method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $doManifestRequestShipmentNumberItem) {
            // validation for constraint: maxLength(39)
            if (mb_strlen($doManifestRequestShipmentNumberItem) > 39) {
                $invalidValues[] = var_export($doManifestRequestShipmentNumberItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 39', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set shipmentNumber value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param string[] $shipmentNumber
     * @return \StructType\DoManifestRequest
     */
    public function setShipmentNumber(array $shipmentNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($shipmentNumberArrayErrorMessage = self::validateShipmentNumberForArrayConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(shipmentNumber, allShipments)
        if ('' !== ($shipmentNumberChoiceErrorMessage = self::validateShipmentNumberForChoiceConstraintsFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if ('' !== ($shipmentNumberMaxLengthErrorMessage = self::validateShipmentNumberForMaxLengthConstraintFromSetShipmentNumber($shipmentNumber))) {
            throw new \InvalidArgumentException($shipmentNumberMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($shipmentNumber) && count($shipmentNumber) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 50', count($shipmentNumber)), __LINE__);
        }
        if (is_null($shipmentNumber) || (is_array($shipmentNumber) && empty($shipmentNumber))) {
            unset($this->shipmentNumber);
        } else {
            $this->shipmentNumber = $shipmentNumber;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToShipmentNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToShipmentNumber method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToShipmentNumber($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'allShipments',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property shipmentNumber can\'t be set as the property %s is already set. Only one property must be set among these properties: shipmentNumber, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to shipmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DoManifestRequest
     */
    public function addToShipmentNumber($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The shipmentNumber property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(shipmentNumber, allShipments)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToShipmentNumber($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(39)
        if (mb_strlen($item) > 39) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 39', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(50)
        if (is_array($this->shipmentNumber) && count($this->shipmentNumber) >= 50) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 50', count($this->shipmentNumber)), __LINE__);
        }
        $this->shipmentNumber[] = $item;
        return $this;
    }
    /**
     * Get allShipments value
     * @return mixed|null
     */
    public function getAllShipments()
    {
        return isset($this->allShipments) ? $this->allShipments : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAllShipments method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllShipments method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAllShipmentsForChoiceConstraintsFromSetAllShipments($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'shipmentNumber',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property allShipments can\'t be set as the property %s is already set. Only one property must be set among these properties: allShipments, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set allShipments value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $allShipments
     * @return \StructType\DoManifestRequest
     */
    public function setAllShipments($allShipments = null)
    {
        // validation for constraint: choice(shipmentNumber, allShipments)
        if ('' !== ($allShipmentsChoiceErrorMessage = self::validateAllShipmentsForChoiceConstraintsFromSetAllShipments($allShipments))) {
            throw new \InvalidArgumentException($allShipmentsChoiceErrorMessage, __LINE__);
        }
        if (is_null($allShipments) || (is_array($allShipments) && empty($allShipments))) {
            unset($this->allShipments);
        } else {
            $this->allShipments = $allShipments;
        }
        return $this;
    }
}
