<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryAdress StructType
 * Meta information extracted from the WSDL
 * - documentation: Mandatory if further address is to be specified.
 * @subpackage Structs
 */
class DeliveryAdress extends AbstractStructBase
{
    /**
     * The Company
     * Meta information extracted from the WSDL
     * - documentation: Determines whether further address is one of the following types.
     * @var \StructType\NameType
     */
    public $Company;
    /**
     * The Name3
     * Meta information extracted from the WSDL
     * - documentation: Extra data for name extension.
     * - minOccurs: 0
     * @var string
     */
    public $Name3;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - documentation: Contains address data.
     * @var \StructType\NativeAddressType
     */
    public $Address;
    /**
     * The Communication
     * Meta information extracted from the WSDL
     * - documentation: Info about communication.
     * @var \StructType\CommunicationType
     */
    public $Communication;
    /**
     * Constructor method for DeliveryAdress
     * @uses DeliveryAdress::setCompany()
     * @uses DeliveryAdress::setName3()
     * @uses DeliveryAdress::setAddress()
     * @uses DeliveryAdress::setCommunication()
     * @param \StructType\NameType $company
     * @param string $name3
     * @param \StructType\NativeAddressType $address
     * @param \StructType\CommunicationType $communication
     */
    public function __construct(\StructType\NameType $company = null, $name3 = null, \StructType\NativeAddressType $address = null, \StructType\CommunicationType $communication = null)
    {
        $this
            ->setCompany($company)
            ->setName3($name3)
            ->setAddress($address)
            ->setCommunication($communication);
    }
    /**
     * Get Company value
     * @return \StructType\NameType|null
     */
    public function getCompany()
    {
        return $this->Company;
    }
    /**
     * Set Company value
     * @param \StructType\NameType $company
     * @return \StructType\DeliveryAdress
     */
    public function setCompany(\StructType\NameType $company = null)
    {
        $this->Company = $company;
        return $this;
    }
    /**
     * Get Name3 value
     * @return string|null
     */
    public function getName3()
    {
        return $this->Name3;
    }
    /**
     * Set Name3 value
     * @param string $name3
     * @return \StructType\DeliveryAdress
     */
    public function setName3($name3 = null)
    {
        // validation for constraint: string
        if (!is_null($name3) && !is_string($name3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name3, true), gettype($name3)), __LINE__);
        }
        $this->Name3 = $name3;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\NativeAddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\NativeAddressType $address
     * @return \StructType\DeliveryAdress
     */
    public function setAddress(\StructType\NativeAddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Communication value
     * @return \StructType\CommunicationType|null
     */
    public function getCommunication()
    {
        return $this->Communication;
    }
    /**
     * Set Communication value
     * @param \StructType\CommunicationType $communication
     * @return \StructType\DeliveryAdress
     */
    public function setCommunication(\StructType\CommunicationType $communication = null)
    {
        $this->Communication = $communication;
        return $this;
    }
}
