<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CountryType StructType
 * Meta information extracted from the WSDL
 * - documentation: includes | Type of country
 * @subpackage Structs
 */
class CountryType extends AbstractStructBase
{
    /**
     * The countryISOCode
     * Meta information extracted from the WSDL
     * - documentation: Country's ISO-Code (ISO-2-Alpha). | Country specific ISO code.
     * - base: xs:string
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 1
     * @var string
     */
    public $countryISOCode;
    /**
     * The country
     * Meta information extracted from the WSDL
     * - documentation: Name of country.
     * - base: xs:string
     * - maxLength: 30
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The state
     * Meta information extracted from the WSDL
     * - documentation: Name of state.
     * - base: xs:string
     * - maxLength: 35
     * - minOccurs: 0
     * @var string
     */
    public $state;
    /**
     * Constructor method for CountryType
     * @uses CountryType::setCountryISOCode()
     * @uses CountryType::setCountry()
     * @uses CountryType::setState()
     * @param string $countryISOCode
     * @param string $country
     * @param string $state
     */
    public function __construct($countryISOCode = null, $country = null, $state = null)
    {
        $this
            ->setCountryISOCode($countryISOCode)
            ->setCountry($country)
            ->setState($state);
    }
    /**
     * Get countryISOCode value
     * @return string
     */
    public function getCountryISOCode()
    {
        return $this->countryISOCode;
    }
    /**
     * Set countryISOCode value
     * @param string $countryISOCode
     * @return \StructType\CountryType
     */
    public function setCountryISOCode($countryISOCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryISOCode) && !is_string($countryISOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryISOCode, true), gettype($countryISOCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($countryISOCode) && mb_strlen($countryISOCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($countryISOCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryISOCode) && mb_strlen($countryISOCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryISOCode)), __LINE__);
        }
        $this->countryISOCode = $countryISOCode;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\CountryType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($country) && mb_strlen($country) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\CountryType
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($state, true), gettype($state)), __LINE__);
        }
        // validation for constraint: maxLength(35)
        if (!is_null($state) && mb_strlen($state) > 35) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 35', mb_strlen($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
}
